/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.activity;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.css.sdk.R;
import com.css.sdk.cservice.activity.BaseActivity;
import com.css.sdk.cservice.adapter.FullyGridLayoutManager;
import com.css.sdk.cservice.adapter.GridImageAdapter;
import com.css.sdk.cservice.base.CSSErrors;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.base.utils.LogUtils;
import com.css.sdk.cservice.base.utils.ToastUtil;
import com.css.sdk.cservice.business.BusinessRequest;
import com.css.sdk.cservice.business.RequestCallback;
import com.css.sdk.cservice.data.Picture;
import com.css.sdk.cservice.glide.GlideCacheEngine;
import com.css.sdk.cservice.glide.GlideEngine;
import com.css.sdk.cservice.view.CustomEditText;
import com.luck.picture.lib.PictureSelector;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.decoration.GridSpacingItemDecoration;
import com.luck.picture.lib.engine.CacheResourcesEngine;
import com.luck.picture.lib.engine.ImageEngine;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.listener.OnItemClickListener;
import com.luck.picture.lib.listener.OnResultCallbackListener;
import com.luck.picture.lib.permissions.PermissionChecker;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.luck.picture.lib.tools.ScreenUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class FeedBaseActivity
extends BaseActivity {
    private static final String TAG = "css_picture";
    public CustomEditText etFeedbackContent;
    private TextView etNumHint;
    public boolean mLoading;
    private LinearLayout loadingLl;
    public TextView loadingTv;
    public RelativeLayout titleBack;
    public TextView titleTv;
    private RecyclerView picRecyView;
    protected GridImageAdapter mSelectedPicsAdapter;
    private int maxSelectNum = 3;
    protected List<Picture> picNames = new ArrayList<Picture>();
    protected List<Picture> videoNames = new ArrayList<Picture>();
    protected List<Picture> cancelPics = new ArrayList<Picture>();
    private GridImageAdapter.onAddPicClickListener onAddPicClickListener = new GridImageAdapter.onAddPicClickListener(){

        @Override
        public void onAddPicClick() {
            PictureSelector.create((Activity)FeedBaseActivity.this).openGallery(PictureMimeType.ofImage()).loadImageEngine((ImageEngine)GlideEngine.createGlideEngine()).defTheme().setDefPictureStyle((Context)FeedBaseActivity.this).loadCacheResourcesCallback((CacheResourcesEngine)GlideCacheEngine.createCacheEngine()).maxSelectNum(FeedBaseActivity.this.maxSelectNum).minSelectNum(0).maxVideoSelectNum(0).imageSpanCount(4).isReturnEmpty(false).setRequestedOrientation(1).isOriginalImageControl(false).selectionMode(2).previewImage(true).previewVideo(false).enablePreviewAudio(false).isCamera(false).isZoomAnim(true).enableCrop(false).compress(true).synOrAsy(true).isGif(false).openClickSound(false).selectionMedia(FeedBaseActivity.this.mSelectedPicsAdapter.getData()).videoMinSecond(2).videoMaxSecond(30).cutOutQuality(90).minimumCompressSize(100).forResult((OnResultCallbackListener)new OnResultCallbackListener<LocalMedia>(){

                public void onResult(List<LocalMedia> result) {
                    ArrayList<String> pics = new ArrayList<String>();
                    for (LocalMedia media : result) {
                        FeedBaseActivity.this.showLog2pictureSelector(false, media);
                        if (PictureMimeType.eqVideo((String)media.getMimeType())) {
                            if (!media.getPath().endsWith(".mp4")) continue;
                            pics.add(media.getPath());
                            continue;
                        }
                        if (!PictureMimeType.eqImage((String)media.getMimeType())) continue;
                        if (media.getCompressPath().endsWith(".0")) {
                            String newPath = media.getCompressPath().substring(0, media.getCompressPath().length() - 2) + ".jpeg";
                            File errorFile = new File(media.getCompressPath());
                            if (errorFile.exists()) {
                                File newFile = new File(newPath);
                                errorFile.renameTo(newFile);
                                media.setCompressPath(newPath);
                            }
                        }
                        pics.add(media.getCompressPath());
                    }
                    FeedBaseActivity.this.upload(pics);
                    FeedBaseActivity.this.mSelectedPicsAdapter.setList(result);
                    FeedBaseActivity.this.mSelectedPicsAdapter.notifyDataSetChanged();
                }

                public void onCancel() {
                    Log.i((String)FeedBaseActivity.TAG, (String)"PictureSelector Cancel");
                }
            });
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        int layoutId = this.getLayoutId();
        if (layoutId > 0) {
            this.setContentView(layoutId);
        }
        if (savedInstanceState == null) {
            this.clearCache();
        }
        this.initView();
        this.initPicUploadContent(savedInstanceState);
    }

    public abstract int getLayoutId();

    private void initView() {
        this.titleBack = (RelativeLayout)this.findViewById(R.id.css_title_back);
        this.titleTv = (TextView)this.findViewById(R.id.css_title_tv);
        this.etFeedbackContent = (CustomEditText)this.findViewById(R.id.css_et_feedback_content);
        this.etNumHint = (TextView)this.findViewById(R.id.css_et_num);
        this.loadingLl = (LinearLayout)this.findViewById(R.id.css_loading_layout);
        this.loadingTv = (TextView)this.findViewById(R.id.css_loading_tv);
        this.picRecyView = (RecyclerView)this.findViewById(R.id.css_pic_recycler);
        this.titleBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FeedBaseActivity.this.finish();
            }
        });
    }

    private void initPicUploadContent(Bundle savedInstanceState) {
        FullyGridLayoutManager manager = new FullyGridLayoutManager((Context)this, 4, 1, false);
        this.picRecyView.setLayoutManager((RecyclerView.LayoutManager)manager);
        this.picRecyView.addItemDecoration((RecyclerView.ItemDecoration)new GridSpacingItemDecoration(4, ScreenUtils.dip2px((Context)this, (float)8.0f), false));
        this.mSelectedPicsAdapter = new GridImageAdapter((Context)this, this.onAddPicClickListener);
        this.mSelectedPicsAdapter.setSelectMax(this.maxSelectNum);
        if (savedInstanceState != null && savedInstanceState.getParcelableArrayList("selectorList") != null) {
            this.mSelectedPicsAdapter.setList(savedInstanceState.getParcelableArrayList("selectorList"));
        }
        this.mSelectedPicsAdapter.setOnItemClickListener(new OnItemClickListener(){

            public void onItemClick(View view, int position) {
                List<LocalMedia> selectList = FeedBaseActivity.this.mSelectedPicsAdapter.getData();
                if (selectList.size() > 0) {
                    LocalMedia media = selectList.get(position);
                    String mimeType = media.getMimeType();
                    int mediaType = PictureMimeType.getMimeType((String)mimeType);
                    switch (mediaType) {
                        case 2: {
                            FeedBaseActivity.this.preViewVideo(media);
                            break;
                        }
                        case 3: {
                            FeedBaseActivity.this.preViewAudio(media);
                            break;
                        }
                        default: {
                            FeedBaseActivity.this.preViewPic(position, selectList);
                        }
                    }
                }
            }
        });
        this.picRecyView.setAdapter((RecyclerView.Adapter)this.mSelectedPicsAdapter);
    }

    private void preViewPic(int position, List<LocalMedia> selectList) {
        PictureSelector.create((Activity)this).themeDefStyle().setDefPictureStyle((Context)this).setRequestedOrientation(1).isNotPreviewDownload(true).loadImageEngine((ImageEngine)GlideEngine.createGlideEngine()).openExternalPreview(position, selectList);
    }

    private void preViewAudio(LocalMedia media) {
        PictureSelector.create((Activity)this).externalPictureAudio(PictureMimeType.isContent((String)media.getPath()) ? media.getAndroidQToPath() : media.getPath());
    }

    private void preViewVideo(LocalMedia media) {
        PictureSelector.create((Activity)this).themeDefStyle().setDefPictureStyle((Context)this).externalPictureVideo(TextUtils.isEmpty((CharSequence)media.getAndroidQToPath()) ? media.getPath() : media.getAndroidQToPath());
    }

    public void showLoading() {
        this.mLoading = true;
        this.loadingLl.setVisibility(0);
        this.loadingTv.setVisibility(0);
        this.loadingTv.setText(R.string.css_string_picture_deal);
    }

    public void hideLoading() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (!FeedBaseActivity.this.mLoading) {
                    return;
                }
                FeedBaseActivity.this.mLoading = false;
                FeedBaseActivity.this.loadingLl.setVisibility(8);
                FeedBaseActivity.this.loadingTv.setVisibility(8);
            }
        });
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.mLoading && keyCode == 4) {
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public void upload(ArrayList<String> pics) {
        LogUtils.i("pics is " + pics.toString());
        this.showLoading();
        BusinessRequest.uploadPics(pics, new RequestCallback<Map<String, List<Picture>>>(){

            @Override
            public void onSuccess(Map<String, List<Picture>> result) {
                FeedBaseActivity.this.hideLoading();
                FeedBaseActivity.this.videoNames.clear();
                FeedBaseActivity.this.picNames.clear();
                if (result.containsKey(Constants.JSON_PICNAME)) {
                    FeedBaseActivity.this.picNames.addAll((Collection<Picture>)result.get(Constants.JSON_PICNAME));
                }
                if (result.containsKey(Constants.JSON_VIDEONAME)) {
                    FeedBaseActivity.this.videoNames.addAll((Collection<Picture>)result.get(Constants.JSON_VIDEONAME));
                }
                StringBuffer sb = new StringBuffer();
                for (Picture picture : FeedBaseActivity.this.picNames) {
                    sb.append(picture.getPicName() + "\n");
                }
                for (Picture picture : FeedBaseActivity.this.videoNames) {
                    sb.append(picture.getPicName() + "\n");
                }
                LogUtils.i("uploadPics result: " + sb.toString());
            }

            @Override
            public void onFail(String msg, final int code) {
                FeedBaseActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ToastUtil.showToastTip(FeedBaseActivity.this.getApplicationContext(), CSSErrors.getErrorMessage(code), false);
                        FeedBaseActivity.this.hideLoading();
                    }
                });
            }
        });
    }

    public boolean isContentEmpty() {
        String content = this.etFeedbackContent.getText().toString().trim();
        if (content.isEmpty()) {
            ToastUtil.showToastTip(this.getApplicationContext(), R.string.css_string_feedback_content_empty, false);
            return true;
        }
        return false;
    }

    public void clearData() {
        this.etFeedbackContent.setText("");
        this.picNames.clear();
        this.videoNames.clear();
        this.cancelPics.clear();
    }

    private void clearCache() {
        if (PermissionChecker.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE")) {
            PictureFileUtils.deleteAllCacheDirFile((Context)this);
        } else {
            PermissionChecker.requestPermissions((Activity)this, (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, (int)1);
        }
    }

    private void showLog2pictureSelector(boolean b, LocalMedia media) {
        if (!b) {
            return;
        }
        LogUtils.i("\u662f\u5426\u538b\u7f29:" + media.isCompressed());
        LogUtils.i("\u538b\u7f29:" + media.getCompressPath());
        LogUtils.i("\u539f\u56fe:" + media.getPath());
        LogUtils.i("\u662f\u5426\u88c1\u526a:" + media.isCut());
        LogUtils.i("\u88c1\u526a:" + media.getCutPath());
        LogUtils.i("\u662f\u5426\u5f00\u542f\u539f\u56fe:" + media.isOriginal());
        LogUtils.i("\u539f\u56fe\u8def\u5f84:" + media.getOriginalPath());
        LogUtils.i("Android Q \u7279\u6709Path:" + media.getAndroidQToPath());
        LogUtils.i("\u5bbd\u9ad8: " + media.getWidth() + "x" + media.getHeight());
        LogUtils.i("Size: " + media.getSize());
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.mSelectedPicsAdapter != null && this.mSelectedPicsAdapter.getData() != null && this.mSelectedPicsAdapter.getData().size() > 0) {
            outState.putParcelableArrayList("selectorList", (ArrayList)this.mSelectedPicsAdapter.getData());
        }
    }
}

