/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.unity;

import android.app.Activity;
import android.text.TextUtils;
import com.css.sdk.cservice.base.utils.LogUtils;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class CSSDKBaseProxy {
    protected static final String TAG = "CSSDKProxy ===>";
    private static WeakReference<Activity> sActivity;

    protected static Activity getActivity() {
        return sActivity == null ? null : (Activity)sActivity.get();
    }

    protected static void setsActivity(Activity activity) {
        if (activity == null) {
            return;
        }
        if (sActivity != null) {
            sActivity.clear();
        }
        sActivity = new WeakReference<Activity>(activity);
    }

    protected static void unityLogi(String msg) {
        LogUtils.i("unityLogi:" + msg);
    }

    public static Activity getCurrentActivity() {
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            Object activityThread = activityThreadClass.getMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
            Field activitiesField = activityThreadClass.getDeclaredField("mActivities");
            activitiesField.setAccessible(true);
            Map activities = (Map)activitiesField.get(activityThread);
            for (Object activityRecord : activities.values()) {
                Class<?> activityRecordClass = activityRecord.getClass();
                Field pausedField = activityRecordClass.getDeclaredField("paused");
                pausedField.setAccessible(true);
                if (pausedField.getBoolean(activityRecord)) continue;
                Field activityField = activityRecordClass.getDeclaredField("activity");
                activityField.setAccessible(true);
                Activity activity = (Activity)activityField.get(activityRecord);
                return activity;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static HashMap<String, String> convertJsonToMap(String json) {
        if (!TextUtils.isEmpty((CharSequence)json)) {
            try {
                JSONObject object = new JSONObject(json);
                JSONArray ary = object.optJSONArray("array");
                if (ary != null && ary.length() > 0) {
                    HashMap<String, String> data = new HashMap<String, String>();
                    for (int i = 0; i < ary.length(); ++i) {
                        JSONObject element = ary.getJSONObject(i);
                        String k = element.optString("k");
                        String v = element.optString("v");
                        if (TextUtils.isEmpty((CharSequence)k) || TextUtils.isEmpty((CharSequence)v)) continue;
                        data.put(k, v);
                    }
                    return data;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

