/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.base.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

public class NetUtils {
    public static final int TYPE_NONE = -1;
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_WIFI = 1;
    public static final int TYPE_2G = 2;
    public static final int TYPE_3G = 3;
    public static final int TYPE_4G = 4;
    public static final int NETWORK_TD_SCDMA = 17;
    public static final int NETWORK_HUAWEI_TDS_HSDPA = 18;

    public static boolean isNetworkAvailable(Context context) {
        return NetUtils.isNetworkAvailable(NetUtils.getActiveNetworkInfo(context));
    }

    public static boolean isNetworkAvailable(NetworkInfo activeNetwork) {
        return activeNetwork != null && activeNetwork.isConnected();
    }

    public static NetworkInfo getActiveNetworkInfo(Context context) {
        try {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            return cm.getActiveNetworkInfo();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isLessThan4g(Context context) {
        int mode = NetUtils.getNetworkSubType(context);
        return mode != 1 && mode < 4;
    }

    public static int getNetworkSubType(Context context) {
        try {
            if (context == null) {
                return 0;
            }
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo info = cm.getNetworkInfo(1);
            if (info != null && info.isConnectedOrConnecting()) {
                return 1;
            }
            info = cm.getNetworkInfo(0);
            if (null != info && info.isAvailable() && info.isConnectedOrConnecting()) {
                switch (info.getSubtype()) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: {
                        return 2;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 17: 
                    case 18: {
                        return 3;
                    }
                    case 13: {
                        return 4;
                    }
                }
                return 0;
            }
            return -1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }
}

