/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.activity;

import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.MediaController;
import android.widget.TextView;
import android.widget.VideoView;
import com.css.sdk.R;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.tools.SdkVersionUtils;
import java.util.ArrayList;

public class CssVideoPlayActivity
extends AppCompatActivity
implements MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnPreparedListener,
View.OnClickListener {
    private String videoPath;
    private ImageButton ibLeftBack;
    private MediaController mMediaController;
    private VideoView mVideoView;
    private TextView tvConfirm;
    private ImageView iv_play;
    private int mPositionWhenPaused = -1;
    public static String VIDEO_PATH = "video_path";
    private LinearLayout loadingLl;
    public TextView loadingTv;
    public boolean mLoading;

    public boolean isImmersive() {
        return true;
    }

    protected void onCreate(Bundle savedInstanceState) {
        this.getWindow().addFlags(0x4000000);
        this.setContentView(R.layout.css_activity_video_play);
        super.onCreate(savedInstanceState);
        this.initWidgets();
        this.showLoading();
    }

    protected void initWidgets() {
        this.videoPath = this.getIntent().getStringExtra(VIDEO_PATH);
        if (TextUtils.isEmpty((CharSequence)this.videoPath)) {
            LocalMedia media = (LocalMedia)this.getIntent().getParcelableExtra("mediaKey");
            if (media == null || TextUtils.isEmpty((CharSequence)media.getPath())) {
                this.finish();
                return;
            }
            this.videoPath = media.getPath();
        }
        if (TextUtils.isEmpty((CharSequence)this.videoPath)) {
            this.finish();
            return;
        }
        this.ibLeftBack = (ImageButton)this.findViewById(R.id.css_imagebtn_left_back);
        this.mVideoView = (VideoView)this.findViewById(R.id.video_view);
        this.tvConfirm = (TextView)this.findViewById(R.id.tv_confirm);
        this.mVideoView.setBackgroundColor(-16777216);
        this.iv_play = (ImageView)this.findViewById(R.id.iv_play);
        this.mMediaController = new MediaController((Context)this);
        this.mVideoView.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
        this.mVideoView.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
        this.mVideoView.setMediaController(this.mMediaController);
        this.ibLeftBack.setOnClickListener((View.OnClickListener)this);
        this.iv_play.setOnClickListener((View.OnClickListener)this);
        this.tvConfirm.setOnClickListener((View.OnClickListener)this);
        this.loadingLl = (LinearLayout)this.findViewById(R.id.css_loading_layout);
        this.loadingTv = (TextView)this.findViewById(R.id.css_loading_tv);
    }

    public void onStart() {
        if (SdkVersionUtils.checkedAndroid_Q() && PictureMimeType.isContent((String)this.videoPath)) {
            this.mVideoView.setVideoURI(Uri.parse((String)this.videoPath));
        } else {
            this.mVideoView.setVideoPath(this.videoPath);
        }
        this.mVideoView.start();
        super.onStart();
    }

    public void onPause() {
        this.mPositionWhenPaused = this.mVideoView.getCurrentPosition();
        this.mVideoView.stopPlayback();
        super.onPause();
    }

    protected void onDestroy() {
        this.mMediaController = null;
        this.mVideoView = null;
        this.iv_play = null;
        super.onDestroy();
    }

    public void onResume() {
        if (this.mPositionWhenPaused >= 0) {
            this.mVideoView.seekTo(this.mPositionWhenPaused);
            this.mPositionWhenPaused = -1;
        }
        super.onResume();
    }

    public boolean onError(MediaPlayer player, int arg1, int arg2) {
        this.hideLoading();
        return false;
    }

    public void onCompletion(MediaPlayer mp) {
        if (null != this.iv_play) {
            this.iv_play.setVisibility(0);
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.css_imagebtn_left_back) {
            this.onBackPressed();
        } else if (id2 == R.id.iv_play) {
            this.mVideoView.start();
            this.iv_play.setVisibility(4);
        } else if (id2 == R.id.tv_confirm) {
            ArrayList<Parcelable> result = new ArrayList<Parcelable>();
            result.add(this.getIntent().getParcelableExtra("mediaKey"));
            this.setResult(-1, new Intent().putParcelableArrayListExtra("selectList", result));
            this.onBackPressed();
        }
    }

    public void onBackPressed() {
        this.finish();
    }

    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext((Context)new ContextWrapper(newBase){

            public Object getSystemService(String name) {
                if ("audio".equals(name)) {
                    return this.getApplicationContext().getSystemService(name);
                }
                return super.getSystemService(name);
            }
        });
    }

    public void onPrepared(MediaPlayer mp) {
        mp.setOnInfoListener((mp1, what, extra) -> {
            if (what == 3) {
                this.hideLoading();
                this.mVideoView.setBackgroundColor(0);
                return true;
            }
            return false;
        });
    }

    public void showLoading() {
        this.mLoading = true;
        this.loadingLl.setVisibility(0);
        this.loadingTv.setVisibility(0);
        this.loadingTv.setText(R.string.css_string_picture_deal);
    }

    public void hideLoading() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (!CssVideoPlayActivity.this.mLoading) {
                    return;
                }
                CssVideoPlayActivity.this.mLoading = false;
                CssVideoPlayActivity.this.loadingLl.setVisibility(8);
                CssVideoPlayActivity.this.loadingTv.setVisibility(8);
            }
        });
    }
}

