package com.css.sdk.cservice.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v7.widget.AppCompatEditText;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.widget.TextView;

import com.css.sdk.R;

public class CustomEditText extends AppCompatEditText {

    private int maxLength;
    private TextView numHintTv;
    private boolean isPaste;

    public CustomEditText(Context context) {
        super(context);
    }

    public CustomEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        initAttrs(attrs);
    }

    public CustomEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initAttrs(attrs);
    }

    private void initAttrs(AttributeSet attrs) {
        TypedArray arr = getContext().obtainStyledAttributes(attrs, R.styleable.LimitEditText);
        if (arr != null) {
            maxLength = arr.getInt(R.styleable.LimitEditText_maxLength, 300);
            arr.recycle();
        }
    }

    private int selectionStart;
    private int selectionEnd;
    private int current;

    public void setNumTextView(TextView view) {
        this.numHintTv = view;
        if (maxLength > 0 && view != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(maxLength).append("/").append(maxLength);
            numHintTv.setText(sb.toString());
            addTextChangedListener(new TextWatcher() {
                @Override
                public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                }

                @Override
                public void onTextChanged(CharSequence s, int start, int before, int count) {
                }

                @Override
                public void afterTextChanged(Editable s) {
                    if (isPaste) {
                        dealNumView(s);
                        isPaste = false;
                    }else {
                        dealNumView(s);
                    }
                    int lineCount = getLineCount();
                }
            });
        }
    }

    private void dealNumView(Editable s) {
        current = maxLength - s.length();
        if (current >= 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(current).append("/").append(maxLength);
            numHintTv.setText(sb.toString());
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("0/").append(maxLength);
            numHintTv.setText(sb.toString());
            selectionStart = getSelectionStart();
            selectionEnd = getSelectionEnd();
            int tempSelection = selectionEnd + current;
            s.delete(selectionStart + current, selectionEnd);
            setText(s);
            setSelection(tempSelection);
        }
    }
    @Override
    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        InputConnection connection = super.onCreateInputConnection(outAttrs);
        int imeActions = outAttrs.imeOptions&EditorInfo.IME_MASK_ACTION;
        if ((imeActions&EditorInfo.IME_ACTION_DONE) != 0) {
            // clear the existing action
            outAttrs.imeOptions ^= imeActions;
            // set the DONE action
            outAttrs.imeOptions |= EditorInfo.IME_ACTION_DONE;
        }
        if ((outAttrs.imeOptions&EditorInfo.IME_FLAG_NO_ENTER_ACTION) != 0) {
            outAttrs.imeOptions &= ~EditorInfo.IME_FLAG_NO_ENTER_ACTION;
        }
        return connection;
    }
    @Override
    public boolean onTextContextMenuItem(int id) {
        switch (id) {
            case android.R.id.paste:
                isPaste = true;
                break;
        }
        return super.onTextContextMenuItem(id);
    }

//    private int mLayoutHeight;
//    private int paddingTop;
//    private int paddingBottom;
//    private int mHeight;
//
//    @Override
//    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
//        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
//        Layout mLayout = getLayout();
//        mLayoutHeight = mLayout.getHeight();
//        paddingTop = getTotalPaddingTop();
//        paddingBottom = getTotalPaddingBottom();
//        mHeight = getHeight();
//    }
//
//    @Override
//    public boolean onTouchEvent(MotionEvent event) {
//        boolean result = super.onTouchEvent(event);
//        if (isLand) {
//            getParent().requestDisallowInterceptTouchEvent(true);
//        }
//        return result;
//    }
//
//    @Override
//    protected void onScrollChanged(int horiz, int vert, int oldHoriz, int oldVert) {
//        super.onScrollChanged(horiz, vert, oldHoriz, oldVert);
//        if (isLand) {
//            if (vert == mLayoutHeight + paddingTop + paddingBottom - mHeight) {
//                getParent().requestDisallowInterceptTouchEvent(false);
//            }
//        }
//    }

}
