package com.css.sdk.cservice.imageloader.core;

import android.graphics.Bitmap;
import android.view.View;
import android.widget.ImageView;

import com.css.sdk.cservice.imageloader.ImageLoader;
import com.css.sdk.cservice.imageloader.ImageLoaderConfig;
import com.css.sdk.cservice.utils.ImageUtils;

import java.lang.ref.WeakReference;
import java.util.concurrent.locks.ReentrantLock;

public class ImageRequest {
    private ImageLoader mImageLoader;
    /**
     * 软引用图片对象
     */
    private WeakReference<View> mTarget;

    private String mUrl;

    private String mCacheKey;

    private Bitmap mBitmap;

    private int mDefaultResId;

    private int mErrorResId;

    public int mExpectWidth;

    public int mExpectHeight;
    public ReentrantLock loadFromUriLock;

    public ImageRequest(ImageLoader imageLoader, String url, View imageView, ImageLoaderConfig config, ReentrantLock loadFromUriLock) {
        this.mImageLoader = imageLoader;
        this.mUrl = url;
        this.mTarget = new WeakReference<>(imageView);
        this.mErrorResId = config.mErrorResId;
        this.mDefaultResId = config.mDefaultResId;
        this.loadFromUriLock = loadFromUriLock;

        if (imageView instanceof View) {
            ImageUtils.ImageSize viewSize = ImageUtils.getImageViewSize(mTarget.get());
            mExpectWidth = viewSize.width;
            mExpectHeight = viewSize.height;
            mCacheKey = url.hashCode() + "_w" + mExpectWidth + "_h" + mExpectHeight;
        } else {
            throw new RuntimeException("暂不支持view以外的控件!");
        }

    }

    /**
     * 检测当前的任务是否有必要去执行
     *
     * @return
     */
    public boolean checkTaskNotActual() {
        return checkViewCollected() || checkViewReused();

    }

    /**
     * 检测当前的ImageView是否已经绑定了别的url
     */
    private boolean checkViewReused() {
        String cacheKey = mImageLoader.getCancelableRequestDelegate().getCacheKey(getTarget().hashCode());
        return !mCacheKey.equals(cacheKey);
    }

    /**
     * 检测当前view是否已经被回收
     */
    private boolean checkViewCollected() {
        return mTarget.get() == null;
    }


    public void setBitmap(Bitmap bitmap) {
        mBitmap = bitmap;
    }


    public Bitmap getBitmap() {
        return mBitmap;
    }


    public Object getTarget() {
        return mTarget.get();
    }

    public ImageUtils.ImageSize getExpectSize() {
        return new ImageUtils.ImageSize(mExpectWidth, mExpectHeight);
    }


    public String getCacheKey() {
        return mCacheKey;
    }

    public String getUrl() {
        return mUrl;
    }

    public boolean setResBitmap() {
        if (checkTaskNotActual()) return false;
        Bitmap bm = mBitmap;
        ImageView imageView = (ImageView) getTarget();
        if (imageView == null) return false;
        if (bm == null) return false;
        imageView.setImageBitmap(bm);
        mImageLoader.getCancelableRequestDelegate().remove(getTarget().hashCode());
        return true;
    }

    public void setErrorImageRes() {
        ImageView imageView = (ImageView) mTarget.get();
        if (mTarget == null || imageView == null) return;
        if (mErrorResId == 0) return;
        imageView.setImageResource(mErrorResId);
    }


}
