package com.css.sdk.cservice.adapter;

import android.app.Activity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ImageView;

import com.css.sdk.R;
import com.css.sdk.cservice.base.utils.ToastUtil;
import com.css.sdk.cservice.imageloader.ImageLoader;

import java.util.ArrayList;

public class PictureAdapter extends BaseAdapter {
    private ArrayList<String> images;//当前相册的图片集合
    private Activity mActivity;
    private int max_num;
    private LayoutInflater layoutInflater;

    public void setSelectedPics(ArrayList<String> selectedPics) {
        this.selectedPics = selectedPics;
    }

    private ArrayList<String> selectedPics = new ArrayList<>();
    private OnEventListener listener;

    public PictureAdapter(Activity activity, ArrayList<String> images, int maxnum) {
        this.images = images;
        this.mActivity = activity;
        this.max_num = maxnum;
        this.layoutInflater = LayoutInflater.from(activity);
    }

    public void bindDatas(ArrayList<String> images) {
        this.images = images;
    }

    public void setListener(OnEventListener listener) {
        this.listener = listener;
    }

    @Override
    public int getCount() {
        return images.size();
    }

    @Override
    public Object getItem(int position) {
        return null;
    }

    @Override
    public long getItemId(int position) {
        return 0;
    }

    @Override
    public View getView(final int position, View convertView, ViewGroup parent) {
        ViewHolder holder = null;

        if (convertView == null) {
            convertView = layoutInflater.inflate(R.layout.css_select_picture_item, parent, false);
            holder = new ViewHolder();
            holder.iv = (ImageView) convertView.findViewById(R.id.iv);
            holder.checkBox = (Button) convertView.findViewById(R.id.check);
            convertView.setTag(holder);

        } else {
            holder = (ViewHolder) convertView.getTag();
        }

        holder.checkBox.setVisibility(View.VISIBLE);

        ImageLoader.getInstance().load(images.get(position), holder.iv);

        //是否选中
        boolean isSelected = selectedPics.contains(images.get(position));
        holder.checkBox.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                //若选中的图片多于所设置的上限，不再加入
                if (!v.isSelected() && selectedPics.size() + 1 > max_num) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(mActivity.getResources().getString(R.string.css_string_chose_at_most)).append(" ").append(max_num).append(" ").append(mActivity.getResources().getString(R.string.css_string_sheet));
                    ToastUtil.showToastTip(mActivity.getApplicationContext(), sb.toString(), false);
                    return;
                }

                //二次选择，移除
                if (selectedPics.contains(images.get(position))) {
                    selectedPics.remove(images.get(position));
                } else {
                    //加入数组
                    selectedPics.add(images.get(position));
                }

                if (listener != null) {
                    listener.selectChanged();
                }

                v.setSelected(selectedPics.contains(images.get(position)));
            }
        });

        holder.iv.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (listener != null) {
                    listener.onPreview(position);
                }
            }
        });

        holder.checkBox.setSelected(isSelected);

        return convertView;
    }

    class ViewHolder {
        ImageView iv;
        Button checkBox;
    }

    public ArrayList<String> getSelectedPics() {
        return selectedPics;
    }

    public interface OnEventListener {
        void onPreview(int position);

        void selectChanged();
    }
}
