/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.imageloader.core;

import android.graphics.Bitmap;
import android.view.View;
import android.widget.ImageView;
import com.css.sdk.cservice.imageloader.ImageLoader;
import com.css.sdk.cservice.imageloader.ImageLoaderConfig;
import com.css.sdk.cservice.utils.ImageUtils;
import java.lang.ref.WeakReference;
import java.util.concurrent.locks.ReentrantLock;

public class ImageRequest {
    private ImageLoader mImageLoader;
    private WeakReference<View> mTarget;
    private String mUrl;
    private String mCacheKey;
    private Bitmap mBitmap;
    private int mDefaultResId;
    private int mErrorResId;
    public int mExpectWidth;
    public int mExpectHeight;
    public ReentrantLock loadFromUriLock;

    public ImageRequest(ImageLoader imageLoader, String url, View imageView, ImageLoaderConfig config, ReentrantLock loadFromUriLock) {
        this.mImageLoader = imageLoader;
        this.mUrl = url;
        this.mTarget = new WeakReference<View>(imageView);
        this.mErrorResId = config.mErrorResId;
        this.mDefaultResId = config.mDefaultResId;
        this.loadFromUriLock = loadFromUriLock;
        if (!(imageView instanceof View)) {
            throw new RuntimeException("\u6682\u4e0d\u652f\u6301view\u4ee5\u5916\u7684\u63a7\u4ef6!");
        }
        ImageUtils.ImageSize viewSize = ImageUtils.getImageViewSize((View)this.mTarget.get());
        this.mExpectWidth = viewSize.width;
        this.mExpectHeight = viewSize.height;
        this.mCacheKey = url.hashCode() + "_w" + this.mExpectWidth + "_h" + this.mExpectHeight;
    }

    public boolean checkTaskNotActual() {
        return this.checkViewCollected() || this.checkViewReused();
    }

    private boolean checkViewReused() {
        String cacheKey = this.mImageLoader.getCancelableRequestDelegate().getCacheKey(this.getTarget().hashCode());
        return !this.mCacheKey.equals(cacheKey);
    }

    private boolean checkViewCollected() {
        return this.mTarget.get() == null;
    }

    public void setBitmap(Bitmap bitmap) {
        this.mBitmap = bitmap;
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    public Object getTarget() {
        return this.mTarget.get();
    }

    public ImageUtils.ImageSize getExpectSize() {
        return new ImageUtils.ImageSize(this.mExpectWidth, this.mExpectHeight);
    }

    public String getCacheKey() {
        return this.mCacheKey;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public boolean setResBitmap() {
        if (this.checkTaskNotActual()) {
            return false;
        }
        Bitmap bm = this.mBitmap;
        ImageView imageView = (ImageView)this.getTarget();
        if (imageView == null) {
            return false;
        }
        if (bm == null) {
            return false;
        }
        imageView.setImageBitmap(bm);
        this.mImageLoader.getCancelableRequestDelegate().remove(this.getTarget().hashCode());
        return true;
    }

    public void setErrorImageRes() {
        ImageView imageView = (ImageView)this.mTarget.get();
        if (this.mTarget == null || imageView == null) {
            return;
        }
        if (this.mErrorResId == 0) {
            return;
        }
        imageView.setImageResource(this.mErrorResId);
    }
}

