/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.base.http;

import android.text.TextUtils;
import com.css.sdk.cservice.base.http.HttpResponse;
import com.css.sdk.cservice.base.utils.LogUtils;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class HttpClient {
    public static String METHOD_GET = "GET";
    public static String METHOD_HEAD = "HEAD";
    public static String METHOD_POST = "POST";
    private static final String BOUNDARY = UUID.randomUUID().toString().toLowerCase().replaceAll("-", "");
    private static final String PREFIX = "--";
    private static final String LINE_END = "\r\n";
    private static final String PIC_REQUESTKEY = "picFile";
    private static final String VIDEO_REQUESTKEY = "video_file";
    private URL url;
    private int connectTimeout = 120000;
    private int readTimeout = 120000;
    private boolean useCaches = false;
    private boolean redirected = false;
    private String requestMethod = METHOD_GET;
    private String requestBody = null;
    private String userAgent = null;
    private String enctyType = null;
    private Map<String, String> headerMap = new ConcurrentHashMap<String, String>();
    private HttpURLConnection conn;
    private String mHostName;

    public static HttpClient builder() {
        return new HttpClient();
    }

    private HttpClient() {
    }

    public HttpClient setUrl(String url) throws MalformedURLException {
        this.url = new URL(url);
        return this;
    }

    public HttpClient setConnectTimeout(int timeout) {
        this.connectTimeout = timeout;
        return this;
    }

    public HttpClient setReadTimeout(int timeout) {
        this.readTimeout = timeout;
        return this;
    }

    public HttpClient setUseCaches(boolean use) {
        this.useCaches = use;
        return this;
    }

    public HttpClient setRequestMethod(String method) {
        this.requestMethod = method;
        return this;
    }

    public HttpClient setRequestHeader(String key, String value) {
        if (!TextUtils.isEmpty((CharSequence)key) && value != null) {
            this.headerMap.put(key, value);
        }
        return this;
    }

    public HttpClient setRequestBody(String body) {
        this.requestBody = body;
        return this;
    }

    public HttpClient setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public HttpClient setEnctyType(String enctyType) {
        this.enctyType = enctyType;
        return this;
    }

    public HttpResponse request() throws Exception {
        if (this.url == null) {
            throw new IOException("URL is empty");
        }
        this.makeConnection();
        return new HttpResponse(this.conn);
    }

    public HttpResponse requestUpload(Map<String, String> params, List<String> files) throws Exception {
        if (this.url == null) {
            throw new IOException("URL is empty");
        }
        this.makeUploadConnection(params, files);
        return new HttpResponse(this.conn);
    }

    private void makeUploadConnection(Map<String, String> params, List<String> files) throws Exception {
        this.conn = (HttpURLConnection)this.url.openConnection();
        this.conn.setConnectTimeout(this.connectTimeout);
        this.conn.setReadTimeout(this.readTimeout);
        this.conn.setDoOutput(true);
        this.conn.setDoInput(true);
        this.conn.setUseCaches(this.useCaches);
        this.conn.setChunkedStreamingMode(0x100000);
        this.conn.setRequestProperty("Accept", "*/*");
        this.conn.setRequestProperty("Connection", "keep-alive");
        this.conn.setRequestProperty("Charset", "UTF-8");
        this.conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
        OutputStream os = this.conn.getOutputStream();
        HttpClient.writeParams(params, os);
        HttpClient.writeFile(files, os);
        String endTarget = PREFIX + BOUNDARY + PREFIX + LINE_END;
        os.write(endTarget.getBytes());
        if (os != null) {
            os.close();
        }
    }

    public HttpClient setmHostName(String mHostName) {
        this.mHostName = mHostName;
        return this;
    }

    private void makeConnection() throws Exception {
        try {
            this.conn = (HttpURLConnection)this.url.openConnection();
            this.conn.setConnectTimeout(this.connectTimeout);
            this.conn.setReadTimeout(this.readTimeout);
            this.conn.setUseCaches(this.useCaches);
            this.conn.setRequestMethod(this.requestMethod);
            this.conn.setInstanceFollowRedirects(true);
            if (this.userAgent != null) {
                this.conn.setRequestProperty("User-Agent", this.userAgent);
            }
            if (this.headerMap != null && !this.headerMap.isEmpty()) {
                for (Map.Entry<String, String> entry : this.headerMap.entrySet()) {
                    this.conn.setRequestProperty(entry.getKey(), this.headerMap.get(entry.getKey()));
                }
            }
            if (METHOD_GET.equals(this.requestMethod) || METHOD_HEAD.equals(this.requestMethod)) {
                this.conn.setDoOutput(false);
            } else if (METHOD_POST.equals(this.requestMethod)) {
                this.conn.setDoOutput(true);
            }
            if (this.mHostName != null) {
                this.conn.setRequestProperty("Host", this.mHostName);
            }
            if (this.requestBody != null) {
                if (this.enctyType != null) {
                    this.conn.setRequestProperty("Content-type", this.enctyType);
                } else {
                    this.conn.setRequestProperty("Content-type", "application/json;charset=UTF-8");
                }
                OutputStream os = this.conn.getOutputStream();
                byte[] bytes = this.requestBody.getBytes("UTF-8");
                String res = new String(bytes, "UTF-8");
                LogUtils.i("request map result" + res);
                os.write(bytes);
                os.close();
            }
            if (this.conn.getResponseCode() >= 300 && this.conn.getResponseCode() < 400) {
                String location = this.conn.getHeaderField("Location");
                if (TextUtils.isEmpty((CharSequence)location)) {
                    location = this.conn.getHeaderField("location");
                }
                if (!this.redirected && !TextUtils.isEmpty((CharSequence)location)) {
                    this.redirected = true;
                    this.setUrl(location);
                    this.makeConnection();
                }
            }
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
    }

    private static void writeParams(Map<String, String> requestText, OutputStream os) throws Exception {
        try {
            if (requestText == null || requestText.isEmpty()) {
                return;
            }
            StringBuilder requestParams = new StringBuilder();
            Set<Map.Entry<String, String>> set = requestText.entrySet();
            for (Map.Entry<String, String> entry : set) {
                requestParams.append(PREFIX).append(BOUNDARY).append(LINE_END);
                requestParams.append("Content-Disposition: form-data; name=\"").append(entry.getKey()).append("\"").append(LINE_END);
                requestParams.append("Content-Type: text/plain; charset=utf-8").append(LINE_END);
                requestParams.append("Content-Transfer-Encoding: 8bit").append(LINE_END);
                requestParams.append(LINE_END);
                requestParams.append(entry.getValue());
                requestParams.append(LINE_END);
            }
            os.write(requestParams.toString().getBytes());
            os.flush();
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(List<String> files, OutputStream os) {
        Closeable is = null;
        try {
            if (files == null || files.isEmpty()) {
                return;
            }
            ArrayList<String> videoFiles = new ArrayList<String>();
            ArrayList<String> imgFiles = new ArrayList<String>();
            for (String f : files) {
                if (f.endsWith(".mp4")) {
                    videoFiles.add(f);
                    continue;
                }
                imgFiles.add(f);
            }
            HttpClient.uploadFileInCode(videoFiles, VIDEO_REQUESTKEY, os);
            HttpClient.uploadFileInCode(imgFiles, PIC_REQUESTKEY, os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            HttpClient.closeStream(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void uploadFileInCode(List<String> files, String requestKey, OutputStream os) {
        boolean first = false;
        InputStream is = null;
        try {
            if (files.size() > 0) {
                StringBuilder requestParams = new StringBuilder();
                for (String f : files) {
                    File file = new File(f);
                    if (!first) {
                        requestParams.append(PREFIX).append(BOUNDARY).append(LINE_END);
                        requestParams.append("Content-Disposition: form-data; name=\"").append(requestKey).append("\"; filename=\"").append(file.getName()).append("\"").append(LINE_END);
                        requestParams.append("Content-Type: application/octet-stream; charset=UTF-8\r\n");
                        requestParams.append(LINE_END);
                    }
                    first = true;
                    os.write(requestParams.toString().getBytes());
                    is = new BufferedInputStream(new FileInputStream(file));
                    byte[] bytes = new byte[1024];
                    int len = -1;
                    while ((len = is.read(bytes)) != -1) {
                        os.write(bytes, 0, len);
                    }
                    os.write(LINE_END.getBytes());
                    os.flush();
                }
                LogUtils.i("file upload string :" + requestParams.toString());
            }
        }
        catch (Throwable e) {
            LogUtils.i("file upload hase error :" + e.getMessage());
        }
        finally {
            try {
                is.close();
            }
            catch (Exception requestParams) {}
        }
    }

    private static void closeStream(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

