package com.css.sdk.cservice.activity;

import android.content.Intent;
import android.support.design.widget.TabLayout;
import android.text.TextUtils;
import android.view.View;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;

import com.css.sdk.R;
import com.css.sdk.cservice.adapter.HorizonTabAdapter;
import com.css.sdk.cservice.adapter.SimpleTextGridViewAdapter;
import com.css.sdk.cservice.base.CSSErrors;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.business.BusinessRequest;
import com.css.sdk.cservice.business.RequestCallback;
import com.css.sdk.cservice.data.FaqItem;
import com.css.sdk.cservice.data.FaqTypeItem;
import com.css.sdk.cservice.listener.CSSExistNewReplyCallback;
import com.css.sdk.cservice.userdata.GlobalData;
import com.css.sdk.cservice.view.CssRoundBtn;

import java.util.ArrayList;
import java.util.List;

public class FaqActivity extends AbstractBaseActivity {

    private List<FaqItem> faqs = new ArrayList<>();
    List<FaqTypeItem> faqTypeItems;

    // land
    private ListView verticalTabs;
    private HorizonTabAdapter horizonTabAdapter;


    // port
    private TabLayout mTab;


    // common
    private AbsListView tabsContentView;
    private CssRoundBtn qaHistoryBtn;
    private CssRoundBtn qaSubmitBtn;
    private SimpleTextGridViewAdapter contentViewAdapter;
    private LinearLayout loadingView;
    private TextView nodataView;

    @Override
    public int getLayoutId() {
        return R.layout.css_activity_faq;
    }

    @Override
    public void initView() {

        if (isLand) {
            verticalTabs = findViewById(R.id.css_horizontab);
        } else {
            mTab = findViewById(R.id.css_tabs);
        }
        initCommonView();
    }

    private void initCommonView() {
        LinearLayout titleSearch = (LinearLayout) showTitleShortSearch(true);
        showTitleBack(true);
        qaSubmitBtn = findViewById(R.id.css_btn_submit_qa);
        qaHistoryBtn = findViewById(R.id.css_faq_rightbtn);
        tabsContentView = findViewById(R.id.css_faqs_list);
        loadingView = findViewById(R.id.css_loading_layout);
        nodataView = findViewById(R.id.css_recommedfaq_nodata);
        qaHistoryBtn.setAlertIconVisible(View.GONE);
        qaHistoryBtn.setImgVisible(View.GONE);
        titleSearch.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivity(new Intent(FaqActivity.this, FaqListActivity.class));
            }
        });
        qaSubmitBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivity(new Intent(FaqActivity.this, FeedBackActivity.class));
            }
        });
        qaHistoryBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivity(new Intent(FaqActivity.this, HistoryActivity.class));
            }
        });
        tabsContentView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                // 有两个item是没有数据，只是用来充数的
                if (TextUtils.isEmpty(faqs.get(position).id)) {
                    return;
                }
                goToFaqDetail(position);
            }
        });
    }




    @Override
    protected void onResume() {
        super.onResume();
        getNewReply();
    }

    /**
     * 是否存在未读的客服信息
     */
    private void getNewReply() {
        BusinessRequest.getExistNewReplyInner(new CSSExistNewReplyCallback() {
            @Override
            public void hasNewReplySuccess(boolean hasMsg) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        if (hasMsg) {
                            qaHistoryBtn.setAlertIconVisible(View.VISIBLE);
                        } else {
                            qaHistoryBtn.setAlertIconVisible(View.GONE);
                        }
                    }
                });
            }

            @Override
            public void hasNewReplyFail(String msg) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        qaHistoryBtn.setAlertIconVisible(View.VISIBLE);
                    }
                });
            }
        });
    }

    @Override
    public void initData() {
        faqTypeItems = GlobalData.getTypeItems();
        if (faqTypeItems == null || faqTypeItems.size() <= 0) {
            showError(CSSErrors.CSS_ERROR_RESPONSE_JSON_EXCEPTION);
            return;
        }
        if (isLand) {
            initDatainLand();
        } else {
            initDatainPort();
        }

    }

    private void initDatainPort() {
        // 初始化上方的tab页面
        initTabLayout();
        requestFaq(0);
        //初始化对应的listview
        initFaqList();
    }

    private void initFaqList() {
        tabsContentView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                // 有两个item是没有数据，只是用来充数的
                if (TextUtils.isEmpty(faqs.get(position).id)) {
                    return;
                }
                goToFaqDetail(position);
            }
        });

    }

    private void initTabLayout() {
        List<String> tabs = new ArrayList<>();
        for (FaqTypeItem item : faqTypeItems) {
            tabs.add(item.getFaqTypeByLanguage(this));
        }
        for (String tag : tabs) {
            mTab.addTab(mTab.newTab().setText(tag));
        }
        mTab.addOnTabSelectedListener(new TabLayout.OnTabSelectedListener() {
            @Override
            public void onTabSelected(TabLayout.Tab tab) {
                requestFaq(tab.getPosition());
                contentViewAdapter.notifyDataSetChanged();
            }

            @Override
            public void onTabUnselected(TabLayout.Tab tab) {

            }

            @Override
            public void onTabReselected(TabLayout.Tab tab) {

            }
        });
    }


    private void initDatainLand() {
        horizonTabAdapter = new HorizonTabAdapter(this, faqTypeItems);
        verticalTabs.setAdapter(horizonTabAdapter);
        requestFaq(0);
        verticalTabs.setSelection(0);
        verticalTabs.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                horizonTabAdapter.setSelectedId(position);
                horizonTabAdapter.notifyDataSetChanged();
                requestFaq(position);
            }
        });

    }

    private void goToFaqDetail(int position) {
        Intent i = new Intent(FaqActivity.this, FaqDetailActvity.class);
        i.putExtra(Constants.KEY_RECOMMEND_ID, faqs.get(position).id);
        i.putExtra(Constants.KEY_RECOMMEND_NAME, faqs.get(position).getFaqTypeByLanguage(FaqActivity.this));
        startActivity(i);
    }

    @Override
    protected void initExtraData() {

    }


    private void requestFaq(int position) {
        showLoadingView();
        hideNodataView();
        BusinessRequest.getFaqList(faqTypeItems.get(position).getId(), new RequestCallback<List<FaqItem>>() {
            @Override
            public void onSuccess(List<FaqItem> result) {
                hideLoadingView();
                faqs = result;
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {

                        if (faqs == null || faqs.size() <= 0) {
                            tabsContentView.setVisibility(View.GONE);
                            return;
                        } else {
                            // 为了空出最后一行，追加两个entity
                            tabsContentView.setVisibility(View.VISIBLE);
                            faqs.add(new FaqItem());
                            faqs.add(new FaqItem());
                        }
                        contentViewAdapter = new SimpleTextGridViewAdapter(FaqActivity.this, faqs);
                        tabsContentView.setAdapter(contentViewAdapter);
                    }
                });

            }

            @Override
            public void onFail(String msg, int code) {
                hideLoadingView();
                showNodataView();
            }
        });
    }

    private void showLoadingView() {
        if (!loadingView.isShown()) {
            loadingView.setVisibility(View.VISIBLE);
        }
    }

    private void hideLoadingView() {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (loadingView.isShown()) {
                    loadingView.setVisibility(View.GONE);
                }
            }
        });
    }

    private void showNodataView() {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (!nodataView.isShown()) {
                    nodataView.setVisibility(View.VISIBLE);
                }
            }
        });
    }

    private void hideNodataView() {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (nodataView.isShown()) {
                    nodataView.setVisibility(View.GONE);
                }
            }
        });
    }
}
