/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.css.sdk.R;
import com.css.sdk.cservice.data.FaqItem;
import com.css.sdk.cservice.utils.DataFilter;
import com.css.sdk.cservice.utils.LocalInfo;
import java.util.List;

public class RecommendQaAapter
extends BaseAdapter {
    private List<FaqItem> data;
    private Context context;
    private RecommendQAItemClickListener mClickListener;

    public RecommendQaAapter(Context context, RecommendQAItemClickListener listener) {
        this.context = context;
        this.mClickListener = listener;
    }

    public void bindData(List<FaqItem> list) {
        this.data = DataFilter.fitLanguageData(this.context, list);
        this.notifyDataSetChanged();
    }

    public int getCount() {
        return this.data == null ? 0 : this.data.size();
    }

    public Object getItem(int position) {
        return null;
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        ViewHolder hold = null;
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)this.context).inflate(R.layout.css_recommend_qa_list_item, null);
            hold = new ViewHolder(convertView);
            convertView.setTag((Object)hold);
        } else {
            hold = (ViewHolder)convertView.getTag();
        }
        hold.questionEn.setVisibility(8);
        hold.questionZh.setVisibility(0);
        if (LocalInfo.getLanguage(this.context) == LocalInfo.LocalLanguage.ZHSIMPLE) {
            hold.questionZh.setText((CharSequence)this.data.get((int)position).questionZhSimple);
        } else if (LocalInfo.getLanguage(this.context) == LocalInfo.LocalLanguage.ZHTrandition) {
            hold.questionZh.setText((CharSequence)this.data.get((int)position).questionZh);
        } else {
            hold.questionZh.setText((CharSequence)this.data.get((int)position).questionEn);
        }
        hold.root.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RecommendQaAapter.this.mClickListener.onItemClick(position, (FaqItem)RecommendQaAapter.this.data.get(position));
            }
        });
        return convertView;
    }

    class ViewHolder {
        TextView questionZh;
        TextView questionEn;
        LinearLayout root;

        public ViewHolder(View view) {
            this.root = (LinearLayout)view.findViewById(R.id.recommend_item_root);
            this.questionZh = (TextView)view.findViewById(R.id.css_recommend_question_zh);
            this.questionEn = (TextView)view.findViewById(R.id.css_recommend_question_en);
        }
    }

    public static interface RecommendQAItemClickListener {
        public void onItemClick(int var1, FaqItem var2);
    }
}

