/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.View;
import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import com.css.sdk.R;
import com.css.sdk.cservice.activity.AbstractBaseActivity;
import com.css.sdk.cservice.activity.FaqDetailActvity;
import com.css.sdk.cservice.adapter.SimpleTextGridViewAdapter;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.base.utils.LogUtils;
import com.css.sdk.cservice.business.BusinessRequest;
import com.css.sdk.cservice.business.RequestCallback;
import com.css.sdk.cservice.data.FaqItem;
import com.css.sdk.cservice.utils.ToastHelper;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class SubmitSuccessActivity
extends AbstractBaseActivity
implements View.OnClickListener,
AdapterView.OnItemClickListener {
    private GridView mGridView;
    private SimpleTextGridViewAdapter gridViewAdapter;
    private LinearLayout LoadingView;
    private String feedbackResult;
    List<FaqItem> faqs = new ArrayList<FaqItem>();
    private String feedbackId = "";
    private LinearLayout refreshRoot;
    private LinearLayout faqRoot;
    private int freashNum = 1;
    private List<FaqItem> subList;

    @Override
    public int getLayoutId() {
        return R.layout.css_activity_submitsuccess;
    }

    @Override
    public void initView() {
        this.showTitleClose(true);
        this.mGridView = (GridView)this.findViewById(R.id.css_recommedfaq_gridView);
        this.LoadingView = (LinearLayout)this.findViewById(R.id.css_loading_layout);
        this.mGridView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.refreshRoot = (LinearLayout)this.findViewById(R.id.css_refreashqa_root);
        this.refreshRoot.setVisibility(4);
        this.refreshRoot.setOnClickListener((View.OnClickListener)this);
        LinearLayout faqCloseBtn = (LinearLayout)this.findViewById(R.id.css_submitsuccess_close);
        this.faqRoot = (LinearLayout)this.findViewById(R.id.css_recommandqa_root);
        faqCloseBtn.setOnClickListener((View.OnClickListener)this);
    }

    @Override
    public void initData() {
        if (this.faqs == null || this.faqs.size() <= 0) {
            this.faqRoot.setVisibility(8);
            return;
        }
        this.faqRoot.setVisibility(0);
        this.subList = this.getFaqList();
        if (this.subList == null || this.subList.size() <= 0) {
            return;
        }
        if (this.faqs.size() > 4) {
            this.refreshRoot.setVisibility(0);
        }
        this.gridViewAdapter = new SimpleTextGridViewAdapter((Context)this, this.subList);
        this.mGridView.setAdapter((ListAdapter)this.gridViewAdapter);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    protected void initExtraData() {
        this.faqs.clear();
        this.feedbackResult = this.getIntent().getStringExtra("result");
        try {
            JSONObject jsonObject = new JSONObject(this.feedbackResult);
            if (jsonObject.has("data")) {
                JSONObject data = jsonObject.getJSONObject("data");
                JSONArray items = data.getJSONArray("matchFaqs");
                this.feedbackId = data.optString("id");
                JSONObject row = null;
                for (int i = 0; i < items.length(); ++i) {
                    row = items.getJSONObject(i);
                    FaqItem item = new FaqItem();
                    item.parseJsonString(row);
                    this.faqs.add(item);
                }
            } else {
                LogUtils.i("error in json");
            }
        }
        catch (Exception e) {
            LogUtils.i("error in json " + e.getMessage());
        }
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        this.goToDetailWithResult(position);
    }

    private void goToDetailWithResult(int position) {
        Intent i = new Intent((Context)this, FaqDetailActvity.class);
        i.putExtra(Constants.KEY_RECOMMEND_ID, this.subList.get((int)position).id);
        i.putExtra(Constants.KEY_RECOMMEND_NAME, this.subList.get(position).getFaqTypeByLanguage((Context)this));
        i.putExtra(Constants.KEY_QU_ID, this.feedbackId);
        this.startActivityForResult(i, 6001);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.css_refreashqa_root) {
            this.subList = this.getFaqList();
            this.gridViewAdapter.setData(this.subList);
            this.gridViewAdapter.notifyDataSetChanged();
        } else if (id2 == R.id.css_submitsuccess_close) {
            this.commitFinish();
        }
    }

    public List getFaqList() {
        List<FaqItem> subList;
        if (this.faqs.size() >= this.freashNum * 4) {
            subList = this.faqs.subList((this.freashNum - 1) * 4, this.freashNum * 4);
            ++this.freashNum;
        } else {
            if ((this.freashNum - 1) * 4 == this.faqs.size()) {
                this.freashNum = 1;
                return this.getFaqList();
            }
            subList = this.faqs.subList((this.freashNum - 1) * 4, this.faqs.size());
            this.freashNum = 1;
        }
        return subList;
    }

    private void commitFinish() {
        this.showLoading();
        BusinessRequest.fqaFinish(this.feedbackId, new RequestCallback<String>(){

            @Override
            public void onSuccess(String result) {
                SubmitSuccessActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        SubmitSuccessActivity.this.hideLoading();
                        SubmitSuccessActivity.this.finish();
                        ToastHelper.showShortToastCenter(SubmitSuccessActivity.this.getResources().getString(R.string.css_string_thanks_for_evaluate));
                    }
                });
            }

            @Override
            public void onFail(String msg, int code) {
                SubmitSuccessActivity.this.hideLoading();
                SubmitSuccessActivity.this.showError(code);
            }
        });
    }

    private void hideLoading() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (SubmitSuccessActivity.this.LoadingView.isShown()) {
                    SubmitSuccessActivity.this.LoadingView.setVisibility(8);
                }
            }
        });
    }

    private void showLoading() {
        if (!this.LoadingView.isShown()) {
            this.LoadingView.setVisibility(0);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (resultCode) {
            case 6001: {
                if (!data.getBooleanExtra(Constants.KEY_DETIAL_EVALUATE_RESULT, false)) break;
                this.commitFinish();
                break;
            }
            default: {
                LogUtils.w("Unexpected value: " + resultCode, new IllegalStateException("Unexpected value: " + resultCode));
            }
        }
    }
}

