/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.design.widget.TabLayout;
import android.view.KeyEvent;
import android.view.View;
import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import com.css.sdk.R;
import com.css.sdk.cservice.activity.AbstractBaseActivity;
import com.css.sdk.cservice.activity.ChatDetailActivity;
import com.css.sdk.cservice.adapter.HistoryGridViewAdapter;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.base.utils.ToastUtil;
import com.css.sdk.cservice.business.BusinessRequest;
import com.css.sdk.cservice.business.RequestCallback;
import com.css.sdk.cservice.data.HistoryItem;
import java.util.ArrayList;

public class HistoryActivity
extends AbstractBaseActivity
implements TabLayout.BaseOnTabSelectedListener {
    private GridView gridView;
    private HistoryGridViewAdapter adapter;
    private LinearLayout loadingRl;
    private boolean mLoading;
    private ArrayList<HistoryItem> historyList;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    protected void initExtraData() {
    }

    @Override
    public int getLayoutId() {
        return R.layout.css_activity_history;
    }

    @Override
    public void initView() {
        this.showTitleClose(true);
        ArrayList<String> tags = new ArrayList<String>();
        tags.add(this.getResources().getString(R.string.css_text_tab_processing));
        tags.add(this.getResources().getString(R.string.css_text_tab_fixed));
        this.showTitleTab(true, tags, this);
        this.gridView = (GridView)this.findViewById(R.id.css_faq_gridView);
        this.loadingRl = (LinearLayout)this.findViewById(R.id.css_loading_layout);
    }

    @Override
    public void initData() {
        this.requestData(0);
    }

    private void requestData(int statusType) {
        this.showLoading();
        BusinessRequest.getHistoryList(statusType, new RequestCallback<ArrayList<HistoryItem>>(){

            @Override
            public void onSuccess(final ArrayList<HistoryItem> result) {
                HistoryActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        HistoryActivity.this.hideLoading();
                        if (result == null || result.isEmpty()) {
                            ToastUtil.showToastTip(HistoryActivity.this.getApplicationContext(), R.string.css_string_history_empty, false);
                        }
                        HistoryActivity.this.historyList = result;
                        if (HistoryActivity.this.adapter == null) {
                            HistoryActivity.this.adapter = new HistoryGridViewAdapter((Context)HistoryActivity.this, HistoryActivity.this.historyList);
                            HistoryActivity.this.gridView.setAdapter((ListAdapter)HistoryActivity.this.adapter);
                            HistoryActivity.this.gridView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                                    HistoryActivity.this.goHistoryDetail(position);
                                }
                            });
                        } else {
                            HistoryActivity.this.adapter.setDataList(HistoryActivity.this.historyList);
                            HistoryActivity.this.adapter.notifyDataSetChanged();
                        }
                    }
                });
            }

            @Override
            public void onFail(String msg, int code) {
                HistoryActivity.this.hideLoading();
                HistoryActivity.this.showError(code);
            }
        });
    }

    private void goHistoryDetail(int position) {
        HistoryItem item = this.historyList.get(position);
        if (item != null) {
            Intent intent = new Intent((Context)this, ChatDetailActivity.class);
            intent.putExtra(Constants.KEY_DETAIL_ID, item.id);
            intent.putExtra(Constants.KEY_IS_UNREAD, item.status.equals(Constants.QA_STATUS_PROCESSED));
            this.startActivityForResult(intent, 17);
        }
    }

    private void showLoading() {
        this.mLoading = true;
        this.loadingRl.setVisibility(0);
    }

    private void hideLoading() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                HistoryActivity.this.mLoading = false;
                HistoryActivity.this.loadingRl.setVisibility(8);
            }
        });
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.mLoading && keyCode == 4) {
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        Bundle bundle;
        if (resultCode == 17 && data != null && (bundle = data.getExtras()) != null) {
            long orderId = bundle.getLong(Constants.KEY_ORDER_ID);
            int type = bundle.getInt(Constants.KEY_ORDER_CHANGE_TYPE);
            if (this.historyList != null && !this.historyList.isEmpty()) {
                for (HistoryItem item : this.historyList) {
                    if (item.id != orderId) continue;
                    if (type == Constants.ORDER_CHANGE_TO_READED) {
                        item.status = Constants.QA_STATUS_PROCESSED_READ;
                    } else if (type == Constants.ORDER_CHANGE_TO_CLOSED) {
                        item.status = Constants.QA_STATUS_CLOSED;
                    }
                    this.adapter.setDataList(this.historyList);
                    this.adapter.notifyDataSetChanged();
                    break;
                }
            }
        }
    }

    public void onTabSelected(TabLayout.Tab tab) {
        this.requestData(tab.getPosition());
    }

    public void onTabUnselected(TabLayout.Tab tab) {
    }

    public void onTabReselected(TabLayout.Tab tab) {
    }
}

