/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.activity;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.view.View;
import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.css.sdk.R;
import com.css.sdk.cservice.activity.AbstractBaseActivity;
import com.css.sdk.cservice.activity.FaqDetailActvity;
import com.css.sdk.cservice.activity.FaqListActivity;
import com.css.sdk.cservice.activity.FeedBackActivity;
import com.css.sdk.cservice.activity.HistoryActivity;
import com.css.sdk.cservice.adapter.HorizonTabAdapter;
import com.css.sdk.cservice.adapter.SimpleTextGridViewAdapter;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.business.BusinessRequest;
import com.css.sdk.cservice.business.RequestCallback;
import com.css.sdk.cservice.data.FaqItem;
import com.css.sdk.cservice.data.FaqTypeItem;
import com.css.sdk.cservice.listener.CSSExistNewReplyCallback;
import com.css.sdk.cservice.userdata.GlobalData;
import com.css.sdk.cservice.view.CssRoundBtn;
import java.util.ArrayList;
import java.util.List;

public class FaqActivity
extends AbstractBaseActivity {
    private ListView horizonTabs;
    private GridView tabGridView;
    private List<FaqItem> faqs = new ArrayList<FaqItem>();
    private HorizonTabAdapter horizonTabAdapter;
    private SimpleTextGridViewAdapter gridViewAdapter;
    private LinearLayout loadingView;
    private TextView nodataView;
    List<FaqTypeItem> faqTypeItems;
    private CssRoundBtn qaHistoryBtn;
    private CssRoundBtn qaSubmitBtn;

    @Override
    public int getLayoutId() {
        return R.layout.css_activity_faq;
    }

    @Override
    public void initView() {
        LinearLayout titleSearch = (LinearLayout)this.showTitleShortSearch(true);
        this.showTitleBack(true);
        this.horizonTabs = (ListView)this.findViewById(R.id.css_horizontab);
        this.tabGridView = (GridView)this.findViewById(R.id.css_recommedfaq_gridView);
        this.loadingView = (LinearLayout)this.findViewById(R.id.css_loading_layout);
        this.nodataView = (TextView)this.findViewById(R.id.css_recommedfaq_nodata);
        this.qaSubmitBtn = (CssRoundBtn)this.findViewById(R.id.css_btn_submit_qa);
        this.qaHistoryBtn = (CssRoundBtn)this.findViewById(R.id.css_faq_rightbtn);
        this.qaHistoryBtn.setAlertIconVisible(8);
        this.qaHistoryBtn.setImgVisible(8);
        titleSearch.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FaqActivity.this.startActivity(new Intent((Context)FaqActivity.this, FaqListActivity.class));
            }
        });
        this.qaSubmitBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FaqActivity.this.startActivity(new Intent((Context)FaqActivity.this, FeedBackActivity.class));
            }
        });
        this.qaHistoryBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FaqActivity.this.startActivity(new Intent((Context)FaqActivity.this, HistoryActivity.class));
            }
        });
    }

    @Override
    protected void onResume() {
        super.onResume();
        this.getNewReply();
    }

    private void getNewReply() {
        BusinessRequest.getExistNewReplyInner(new CSSExistNewReplyCallback(){

            @Override
            public void hasNewReplySuccess(final boolean hasMsg) {
                FaqActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (hasMsg) {
                            FaqActivity.this.qaHistoryBtn.setAlertIconVisible(0);
                        } else {
                            FaqActivity.this.qaHistoryBtn.setAlertIconVisible(8);
                        }
                    }
                });
            }

            @Override
            public void hasNewReplyFail(String msg) {
                FaqActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        FaqActivity.this.qaHistoryBtn.setAlertIconVisible(0);
                    }
                });
            }
        });
    }

    @Override
    public void initData() {
        this.faqTypeItems = GlobalData.getTypeItems();
        if (this.faqTypeItems == null || this.faqTypeItems.size() <= 0) {
            this.showError(-100);
            return;
        }
        this.horizonTabAdapter = new HorizonTabAdapter((Context)this, this.faqTypeItems);
        this.horizonTabs.setAdapter((ListAdapter)this.horizonTabAdapter);
        this.requestFaq(0);
        this.horizonTabs.setSelection(0);
        this.horizonTabs.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                FaqActivity.this.horizonTabAdapter.setSelectedId(position);
                FaqActivity.this.horizonTabAdapter.notifyDataSetChanged();
                FaqActivity.this.requestFaq(position);
            }
        });
        this.tabGridView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (TextUtils.isEmpty((CharSequence)((FaqItem)((FaqActivity)FaqActivity.this).faqs.get((int)position)).id)) {
                    return;
                }
                FaqActivity.this.goToFaqDetail(position);
            }
        });
    }

    private void goToFaqDetail(int position) {
        Intent i = new Intent((Context)this, FaqDetailActvity.class);
        i.putExtra(Constants.KEY_RECOMMEND_ID, this.faqs.get((int)position).id);
        i.putExtra(Constants.KEY_RECOMMEND_NAME, this.faqs.get(position).getFaqTypeByLanguage((Context)this));
        this.startActivity(i);
    }

    @Override
    protected void initExtraData() {
    }

    private void requestFaq(int position) {
        this.showLoadingView();
        this.hideNodataView();
        BusinessRequest.getFaqList(this.faqTypeItems.get(position).getId(), new RequestCallback<List<FaqItem>>(){

            @Override
            public void onSuccess(List<FaqItem> result) {
                FaqActivity.this.hideLoadingView();
                FaqActivity.this.faqs = result;
                FaqActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (FaqActivity.this.faqs == null || FaqActivity.this.faqs.size() <= 0) {
                            FaqActivity.this.tabGridView.setVisibility(8);
                            return;
                        }
                        FaqActivity.this.tabGridView.setVisibility(0);
                        FaqActivity.this.faqs.add(new FaqItem());
                        FaqActivity.this.faqs.add(new FaqItem());
                        FaqActivity.this.gridViewAdapter = new SimpleTextGridViewAdapter((Context)FaqActivity.this, FaqActivity.this.faqs);
                        FaqActivity.this.tabGridView.setAdapter((ListAdapter)FaqActivity.this.gridViewAdapter);
                    }
                });
            }

            @Override
            public void onFail(String msg, int code) {
                FaqActivity.this.hideLoadingView();
                FaqActivity.this.showNodataView();
            }
        });
    }

    private void showLoadingView() {
        if (!this.loadingView.isShown()) {
            this.loadingView.setVisibility(0);
        }
    }

    private void hideLoadingView() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (FaqActivity.this.loadingView.isShown()) {
                    FaqActivity.this.loadingView.setVisibility(8);
                }
            }
        });
    }

    private void showNodataView() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (!FaqActivity.this.nodataView.isShown()) {
                    FaqActivity.this.nodataView.setVisibility(0);
                }
            }
        });
    }

    private void hideNodataView() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (FaqActivity.this.nodataView.isShown()) {
                    FaqActivity.this.nodataView.setVisibility(8);
                }
            }
        });
    }
}

