package com.css.sdk.cservice.utils;

import android.content.Context;

import java.util.Locale;

/**
 * @ProjectName: customerservicesdk
 * @Package: com.css.sdk.cservice.utils
 * @ClassName: LocalInfo
 * @Description: LocalInfo
 * @Author: Roy
 * @CreateDate: 2020/5/25 15:50
 */

public class LocalInfo {
    public enum LocalLanguage {
        ZHSIMPLE("zhSimple"),
        ZHTrandition("zh"),
        EN("en");
        private String name;

        LocalLanguage(String name) {
            this.name = name;
        }

        String getName() {
            return name;
        }
    }

    public static LocalLanguage getLanguage(Context context) {
        Locale locale = context.getResources().getConfiguration().locale;
        if (locale.equals(Locale.SIMPLIFIED_CHINESE)||locale.toString().contains("zh_CN")) {
            return LocalLanguage.ZHSIMPLE;
        }
        if (locale.equals(Locale.TRADITIONAL_CHINESE)||locale.toString().contains("zh_TW")) {
            return LocalLanguage.ZHTrandition;
        }
        return LocalLanguage.EN;
    }

    public static String getLanguageStr(Context context) {
        return getLanguage(context).getName();
    }
}
