package com.css.sdk.cservice.base.utils;

import android.graphics.Rect;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.EditText;

public class SoftHideKeyBoardUtil {
    public static void assistActivity(View parent, EditText content, EditText contact) {
        new SoftHideKeyBoardUtil(parent, content, contact);
    }

    private View parent;
    private View content;
    private View contact;
    private int usableHeightPrevious;

    private SoftHideKeyBoardUtil(View parent, final EditText content, final EditText contact) {
        this.parent = parent;
        this.content = content;
        this.contact = contact;
        parent.getViewTreeObserver().addOnGlobalLayoutListener(onGlobalLayoutListener);
    }

    private ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener() {
        @Override
        public void onGlobalLayout() {
            possiblyResizeChildOfContent();
        }
    };

    private void possiblyResizeChildOfContent() {
        Rect r = new Rect();
        parent.getWindowVisibleDisplayFrame(r);
        int usableHeightNow = r.bottom - r.top;
        if (usableHeightNow != usableHeightPrevious) {
            int usableHeightSansKeyboard = parent.getRootView().getHeight();
            int heightDifference = usableHeightSansKeyboard - usableHeightNow;
            if (heightDifference > (usableHeightSansKeyboard / 4)) {
                int[] location = new int[2];
                if (contact.isFocused()) {
                    contact.getLocationInWindow(location);
                    int srollHeight = (location[1] + contact.getHeight()) - r.bottom;
                    if (srollHeight > 0) {
                        parent.scrollTo(0, srollHeight);
                    } else {
                        parent.getViewTreeObserver().removeOnGlobalLayoutListener(onGlobalLayoutListener);
                    }
                }
                if (content.isFocused()) {
                    content.getLocationInWindow(location);
                    int srollHeight = location[1] - r.bottom + (content.getHeight() / 3);
                    if (srollHeight > 0) {
                        parent.scrollTo(0, srollHeight);
                    }
                }
            } else {
                parent.scrollTo(0, 0);
            }
            usableHeightPrevious = usableHeightNow;
        }
    }
}
