package com.css.sdk.cservice.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.CheckBox;

import com.css.sdk.R;
import com.css.sdk.cservice.base.FaqTagEnum;

import java.util.ArrayList;
import java.util.List;

/**
 * @ProjectName: customerservicesdk
 * @Package: com.css.sdk.cservice.adapter
 * @ClassName: CssTextGridViewAdapter
 * @Description: CssTextGridViewAdapter
 * @Author: Roy
 * @CreateDate: 2020/5/22 14:46
 */

public class CssTextGridViewAdapter extends BaseAdapter {
    private Context mContext;
    private List<ChoseFaqItem> data;
    private GridViewItemClickListener mListener;

    public CssTextGridViewAdapter(Context context, int faqTagId, GridViewItemClickListener clickListener) {
        mContext = context;
        getData(faqTagId);
        mListener = clickListener;
    }

    public interface GridViewItemClickListener {
        public void onGridItemClick(int id);
    }

    private void getData( int faqTagId) {
        List<String> dataStr = getTags();
        data = new ArrayList<>();
        for (int i = 0; i < dataStr.size(); i++) {
            ChoseFaqItem faqItem = new ChoseFaqItem(i, dataStr.get(i));
            if (faqTagId == i) {
                faqItem.checked = true;
            }
            data.add(faqItem);
        }
    }
    private List getTags() {
        ArrayList<String> strings = new ArrayList<>();
        for (int i = 0; i <FaqTagEnum.values().length; i++) {
            strings.add(getStringFromXml(mContext,FaqTagEnum.values()[i].getResourceId()));
        }
        return strings;
    }
    @Override
    public int getCount() {
        return data == null ? 0 : data.size();
    }

    @Override
    public Object getItem(int position) {
        return null;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder = null;
        if (convertView == null) {
            convertView = LayoutInflater.from(mContext).inflate(R.layout.css_gridview_faqtag_item, parent, false);
            viewHolder = new ViewHolder();
            viewHolder.content = convertView.findViewById(R.id.css_item_content);
            convertView.setTag(viewHolder);

        } else {
            viewHolder = (ViewHolder) convertView.getTag();
        }
        ChoseFaqItem choseItem = data.get(position);
        viewHolder.content.setText(choseItem.name);
        if (choseItem.checked) {
            viewHolder.content.setChecked(true);
        } else {
            viewHolder.content.setChecked(false);
        }
        viewHolder.content.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mListener.onGridItemClick(position);
                refreshData(choseItem);
            }
        });
        return convertView;
    }

    private void refreshData(ChoseFaqItem selected) {
        for (ChoseFaqItem faqItem : data) {
            if (selected.id != faqItem.id) {
                faqItem.checked = false;
            } else {
                faqItem.checked = true;
            }
        }
        notifyDataSetChanged();
    }

    class ViewHolder {
        CheckBox content;
    }

    class ChoseFaqItem {
        int id;
        String name;
        boolean checked;

        ChoseFaqItem(int id, String name) {
            this.id = id;
            this.name = name;
        }
    }

    private String getStringFromXml(Context context,int id) {
        return context.getResources().getString(id);
    }

}
