package com.css.sdk.cservice.activity;

import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.css.sdk.R;
import com.css.sdk.cservice.base.CSSErrors;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.base.utils.LogUtils;
import com.css.sdk.cservice.base.utils.ToastUtil;
import com.css.sdk.cservice.business.BusinessRequest;
import com.css.sdk.cservice.business.RequestCallback;
import com.css.sdk.cservice.data.FaqDetail;
import com.css.sdk.cservice.utils.LocalInfo;

public class RecommendDetailActvity extends BaseActivity {
    private String recommendId;
    private TextView titleTv;
    private RelativeLayout titleBack;
    private TextView questionZhTv;
    private TextView questionEnTv;
    private TextView answerZhTv;
    private TextView answerEnTv;
    private RelativeLayout unhappyTv;
    private RelativeLayout happyTv;
    private LinearLayout loadingLl;
    private TextView bottomHintTv;
    private boolean mLoading;
    private FaqDetail detail;
    private LinearLayout bottomBtnLl;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.css_activity_recommend_detail_actvity);
        recommendId = getIntent().getStringExtra(Constants.KEY_RECOMMEND_ID);
        initView();
        requestData();
    }

    private void initView() {
        titleTv = findViewById(R.id.css_title_tv);
        titleTv.setVisibility(View.GONE);
        titleBack = findViewById(R.id.css_title_back);
        titleBack.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });
        questionZhTv = findViewById(R.id.css_question_zh_tv);
        questionEnTv = findViewById(R.id.css_question_en_tv);
        answerZhTv = findViewById(R.id.css_answer_zh_tv);
        answerEnTv = findViewById(R.id.css_answer_en_tv);
        unhappyTv = findViewById(R.id.css_unhappy);
        bottomHintTv = findViewById(R.id.css_hint);
        bottomBtnLl = findViewById(R.id.css_bottom_btn_ll);
        unhappyTv.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                evaluate(false);
            }
        });
        happyTv = findViewById(R.id.css_happy);
        happyTv.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                evaluate(true);
            }
        });
        loadingLl = findViewById(R.id.css_loading_layout);

    }

    private void showLoading() {
        mLoading = true;
        loadingLl.setVisibility(View.VISIBLE);
    }

    private void hideLoading() {
        if (!mLoading) return;
        mLoading = false;
        loadingLl.setVisibility(View.GONE);
    }

    private void evaluate(boolean isHelp) {
        if (mLoading) {
            return;
        }
        showLoading();
        BusinessRequest.evaluateFqa(recommendId, isHelp, new RequestCallback<String>() {
            @Override
            public void onSuccess(String result) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        hideLoading();
                        bottomHintTv.setText(R.string.css_string_thanks_for_evaluate);
                        bottomBtnLl.setVisibility(View.GONE);
                    }
                });
            }

            @Override
            public void onFail(String msg, int code) {
                hideLoading();
                showError(code);
            }
        });
    }

    private void requestData() {
        if (mLoading) {
            return;
        }
        showLoading();
        BusinessRequest.getFaqDetail(this, recommendId, new RequestCallback<FaqDetail>() {
            @Override
            public void onSuccess(final FaqDetail result) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        hideLoading();
                        detail = result;
//                        if (!TextUtils.isEmpty(detail.questionEn)) {
//                            questionEnTv.setText(detail.questionEn);
//                            questionEnTv.setVisibility(View.VISIBLE);
//                        } else {
                        questionEnTv.setVisibility(View.GONE);
                        answerEnTv.setVisibility(View.GONE);

                        if (!TextUtils.isEmpty(detail.question)) {
                            questionZhTv.setText(detail.question);
                            questionZhTv.setVisibility(View.VISIBLE);
                        } else {
                            questionZhTv.setVisibility(View.GONE);
                        }

//                        if (!TextUtils.isEmpty(detail.answerEn)) {
//                            answerEnTv.setText(detail.answerEn);
//                            answerEnTv.setVisibility(View.VISIBLE);
//                        } else {
//                        }

                        if (!TextUtils.isEmpty(detail.answer)) {
                            answerZhTv.setText(detail.answer);
                            answerZhTv.setVisibility(View.VISIBLE);
                        } else {
                            answerZhTv.setVisibility(View.GONE);
                        }
                    }
                });
            }

            @Override
            public void onFail(final String msg, int code) {
                hideLoading();
                showError(code);
            }
        });
    }
}
