package com.css.sdk.cservice.activity;

import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.view.KeyEvent;
import android.view.View;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.css.sdk.R;
import com.css.sdk.cservice.adapter.ChatAdapter;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.base.FaqTagEnum;
import com.css.sdk.cservice.business.BusinessRequest;
import com.css.sdk.cservice.business.RequestCallback;
import com.css.sdk.cservice.data.Chat;
import com.css.sdk.cservice.data.OrderDetail;
import com.css.sdk.cservice.data.Picture;

import java.util.ArrayList;

public class DetailActivity extends FeedBaseActivity {

    private long id;//工单id
    private boolean isUnread;
    private OrderDetail detail;
    private LinearLayout bottomLl;
    private TextView bottomHintTv;
    private RelativeLayout leftBtnRl;
    private TextView leftBtnTv;
    private ImageView leftBtnIv;
    private RelativeLayout rightBtnRl;
    private TextView rightBtnTv;
    private ImageView rightBtnIv;
    private ListView chatListview;
    private RelativeLayout appendQuestionRl;
    private TextView appendQuestionTv;
    private LinearLayout chatContainerLl;

    private ImageView appendCloseIv;


    private ChatAdapter chatAdapter;
    private boolean hasClosed;
    private boolean hasReaded;
    private boolean hasChecked;//是否检测了问题类型的高度


    private Handler handler = new Handler() {
        public void handleMessage(android.os.Message msg) {
            int what = msg.what;
            switch (what) {
                case 1:
                    /**
                     * ListView条目控制在最后一行
                     */
                    if (chatAdapter.getCount() > 0) {
                        chatListview.setSelection(chatAdapter.getCount());
                    }
                    clearData();
                    break;

                default:
                    break;
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        id = getIntent().getLongExtra(Constants.KEY_DETAIL_ID, 0);
        isUnread = getIntent().getBooleanExtra(Constants.KEY_IS_UNREAD, false);
        initView();
        requestData();
    }

    @Override
    public int getLayoutId() {
        return R.layout.css_activity_detail;
    }

    private void initView() {
        titleTv.setVisibility(View.GONE);
        appendCloseIv = findViewById(R.id.css_append_close);
        appendQuestionTv = findViewById(R.id.css_feedback_append);
        chatContainerLl = findViewById(R.id.css_detail_container);
        bottomLl = findViewById(R.id.css_question_detail_bottom_ll);
        bottomHintTv = findViewById(R.id.css_question_detail_hint);
        leftBtnRl = findViewById(R.id.css_question_detail_left_btn);
        leftBtnIv = findViewById(R.id.css_bottom_left_btn_iv);
        leftBtnTv = findViewById(R.id.css_bottom_left_btn_tv);

        appendQuestionRl = findViewById(R.id.append_question_rl);
        appendQuestionRl.setVisibility(View.GONE);
        rightBtnRl = findViewById(R.id.css_question_detail_right_btn);
        rightBtnIv = findViewById(R.id.css_bottom_right_btn_iv);
        rightBtnTv = findViewById(R.id.css_bottom_right_btn_tv);
        leftBtnRl.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                leftClick();
            }
        });
        chatListview = findViewById(R.id.css_question_chat_listview);
        appendCloseIv.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                closeAppend();
            }
        });
        appendQuestionTv.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                feedBack();
            }
        });
        rightBtnRl.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                rightClick();
            }
        });
    }

    private void feedBack() {
        if (isContentEmpty()) {
            return;
        }
        if (mLoading) {
            return;
        }
        showLoading();
        final String content = etFeedbackContent.getText().toString().trim();
        BusinessRequest.feedBackN(this, String.valueOf(id), picNames, videoNames,cancelPics, selectedQaType.getTag(), "", content, new RequestCallback<String>() {
            @Override
            public void onSuccess(String result) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        hideLoading();
                        Chat chat = new Chat();
                        chat.send = "ask";
                        chat.original = content;
                        ArrayList<String> selected = new ArrayList<>();
                        for (Picture file:picNames) {
                            selected.add(file.getPicName());
                        }
                        chat.pics = selected;
                        closeAppend();
                        appendQuestion(chat);
                        checkSpHelper();
//                        spHelper.putString(Constants.LAST_QA_TYPE, selectedQaType);

                    }
                });
            }

            @Override
            public void onFail(String msg, int code) {
                hideLoading();
                showError(code);
            }
        });
    }

    private void closeAppend() {
        hideSoftKeyboard();
        appendQuestionRl.startAnimation(AnimationUtils.loadAnimation(DetailActivity.this, R.anim.css_exit_top_to_bottom));
        appendQuestionRl.setVisibility(View.GONE);
    }

    private void leftClick() {
        if ((detail.status.equals(Constants.QA_STATUS_PROCESSED)
                || detail.status.equals(Constants.QA_STATUS_PROCESSED_READ)) && (!detail.evaluated)) {
            appendQuestionRl.setVisibility(View.VISIBLE);
            appendQuestionRl.startAnimation(AnimationUtils.loadAnimation(DetailActivity.this, R.anim.css_enter_bottom_to_up));
            if (!hasChecked) {
                hasChecked = true;
//                dealTypeTvHeight();
            }

        } else if (detail.status.equals(Constants.QA_STATUS_CLOSED) && (!detail.evaluated)) {
            evaluate(false);
        }
    }

    private void evaluate(boolean isGood) {
        if (mLoading) return;
        showLoading();
        BusinessRequest.evaluateWorkOrder(String.valueOf(id), isGood, new RequestCallback<String>() {
            @Override
            public void onSuccess(String result) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        hideLoading();
                        detail.status = Constants.QA_STATUS_CLOSED;
                        detail.evaluated = true;
                        dealBottomRl(detail.status);
                    }
                });
            }

            @Override
            public void onFail(String msg, int code) {
                hideLoading();
                showError(code);
            }
        });
    }

    private void commitFinish() {
        if (mLoading) return;
        showLoading();
        BusinessRequest.fqaFinish(String.valueOf(id), new RequestCallback<String>() {
            @Override
            public void onSuccess(String result) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        hideLoading();
                        hasClosed = true;
                        detail.status = Constants.QA_STATUS_CLOSED;
                        dealBottomRl(detail.status);
                    }
                });
            }

            @Override
            public void onFail(final String msg, int code) {
                hideLoading();
                showError(code);
            }
        });
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (appendQuestionRl.getVisibility() == View.VISIBLE && keyCode == KeyEvent.KEYCODE_BACK) {
            appendQuestionRl.setVisibility(View.GONE);
            return true;//不执行父类点击事件
        }
        return super.onKeyDown(keyCode, event);//继续执行父类其他点击事件
    }

    private void rightClick() {
        if (detail.status.equals(Constants.QA_STATUS_PROCESSED)
                || detail.status.equals(Constants.QA_STATUS_PROCESSED_READ)) {
            commitFinish();

        } else if (!detail.evaluated) {
            evaluate(true);
        } else {
            finish();
            startActivity(new Intent(this, FeedBackActivity.class));
        }
    }

    private void dealBottomRl(String status) {
        if (status.equals(Constants.QA_STATUS_WAITING)
                || status.equals(Constants.QA_STATUS_WAITING_APPEND)
                || status.equals(Constants.QA_STATUS_PROCESSING)) {
            bottomLl.setVisibility(View.GONE);
        } else if (status.equals(Constants.QA_STATUS_PROCESSED) || status.equals(Constants.QA_STATUS_PROCESSED_READ)) {
            bottomLl.setVisibility(View.VISIBLE);
            bottomHintTv.setVisibility(View.GONE);

            leftBtnRl.setVisibility(View.VISIBLE);
            setDrawable(true, R.drawable.css_sent_question_blue, R.string.css_string_append_question);
            rightBtnRl.setVisibility(View.VISIBLE);
            setDrawable(false, R.drawable.css_btn_check, R.string.css_string_question_solved_text);
        } else if (status.equals(Constants.QA_STATUS_CLOSED) || status.equals(Constants.QA_STATUS_CLOSED_TIMEOUT)) {
            if (detail.evaluated) {
                bottomLl.setVisibility(View.VISIBLE);
                bottomHintTv.setVisibility(View.VISIBLE);
                bottomHintTv.setText(R.string.css_string_question_solved_hint);

                leftBtnRl.setVisibility(View.GONE);
                rightBtnRl.setVisibility(View.VISIBLE);
                setDrawable(false, R.drawable.css_sent_question_white, R.string.css_string_feedback_new);
            } else {
                bottomLl.setVisibility(View.VISIBLE);
                bottomHintTv.setVisibility(View.VISIBLE);
                bottomHintTv.setText(R.string.css_string_wait_comment_hint);

                rightBtnRl.setVisibility(View.VISIBLE);
                setDrawable(true, R.drawable.css_face_unhappy, R.string.css_string_satisfy_no);
                leftBtnRl.setVisibility(View.VISIBLE);
                setDrawable(false, R.drawable.css_face_happy, R.string.css_string_satisfy_yes);
            }
        }
    }

    /**
     * 屏幕适配
     */
    private void setDrawable(boolean isLeft, final int resId, int stringId) {
        String text = getString(stringId);
        if (isLeft) {
            leftBtnTv.setText(text);
            leftBtnIv.setVisibility(View.VISIBLE);
            leftBtnIv.setImageDrawable(getResources().getDrawable(resId));
        } else {
            rightBtnTv.setText(text);
            rightBtnIv.setVisibility(View.VISIBLE);
            rightBtnIv.setImageDrawable(getResources().getDrawable(resId));
        }
        rightBtnTv.post(new Runnable() {
            @Override
            public void run() {
                int right = rightBtnTv.getLineCount();
                int left = leftBtnTv.getLineCount();
                if (right > 1 || left > 1) {
                    rightBtnIv.setVisibility(View.GONE);
                    leftBtnIv.setVisibility(View.GONE);
                }
            }
        });

    }

    //追加问题
    private void appendQuestion(Chat chat) {
        detail.chats.add(chat);
        chatAdapter.bindData(detail);
        chatAdapter.notifyDataSetChanged();
        handler.sendEmptyMessage(1);
    }

    private void requestData() {
        if (mLoading) return;
        showLoading();
        BusinessRequest.getDetail(id, new RequestCallback<OrderDetail>() {
            @Override
            public void onSuccess(final OrderDetail result) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        hideLoading();
                        chatContainerLl.setVisibility(View.VISIBLE);
                        detail = result;
                        selectedQaType=getFaqEnumByTag(detail.type);
                        if (isUnread) {
                            hasReaded = true;
                        }
                        dealBottomRl(detail.status);
                        chatAdapter = new ChatAdapter(DetailActivity.this, detail);
                        chatListview.setAdapter(chatAdapter);
                        handler.sendEmptyMessage(1);
                    }
                });
            }

            @Override
            public void onFail(final String msg, int code) {
                hideLoading();
                showError(code);
            }
        });
    }


    @Override
    public void finish() {
        if (hasClosed || hasReaded) {
            Intent intent = new Intent();
            if (hasReaded) {
                intent.putExtra(Constants.KEY_ORDER_CHANGE_TYPE, Constants.ORDER_CHANGE_TO_READED);
            }
            if (hasClosed) {
                intent.putExtra(Constants.KEY_ORDER_CHANGE_TYPE, Constants.ORDER_CHANGE_TO_CLOSED);
            }

            intent.putExtra(Constants.KEY_ORDER_ID, id);
            setResult(Constants.HISTORY_RESULT_CODE, intent);
        }
        super.finish();
    }

}
