package com.css.sdk.cservice.userdata;

import android.content.Context;
import android.text.TextUtils;

import com.css.sdk.cservice.activity.CssVideoPlayActivity;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.base.utils.DeviceInfoHelper;

import java.lang.ref.WeakReference;

public class GlobalData {

    private static WeakReference<Context> sContext;

    private static String sProductId;

    private static int screenType;
    private static boolean isSensorLand;
    // 帐号sdk的ggid
    private static String sAasGgid;

    // 统计sdk的token
    private static String sAlyToken;

    public static void cacheContext(Context context) {
        if (null == context) {
            return;
        }

        if (sContext != null && sContext.get() == null) {
            sContext.clear();
            sContext = null;
        }

        sContext = new WeakReference<>(context.getApplicationContext());
    }

    public static Context getContext() {
        if (sContext != null && sContext.get() != null) {
            return sContext.get();
        }

        return null;
    }

    public static boolean isNecessaryParamtersAvailable() {
        if (TextUtils.isEmpty(GlobalData.getProductId()) || TextUtils.isEmpty(GlobalData.getAlyToken()) || TextUtils.isEmpty(GlobalData.getAasGgid())) {
            return false;
        }
        return true;
    }

    public static void setConfig(Context context){
        screenType = DeviceInfoHelper.getScreenType(context);
        isSensorLand = DeviceInfoHelper.isSensorLand(context);
    }

    public static int getScreenType() {
        return screenType;
    }

    public static boolean getIsSensorLand() {
        return isSensorLand;
    }

    public static String getProductId() {
        return sProductId;
    }

    public static String getAasGgid() {
        return sAasGgid;
    }

    public static String getAlyToken() {
        return sAlyToken;
    }

    public static void setProductId(String sProductId) {
        GlobalData.sProductId = sProductId;
    }

    public static void setAasGgid(String sAssGgid) {
        GlobalData.sAasGgid = sAssGgid;
    }

    public static void setAlyToken(String sAlyToken) {
        GlobalData.sAlyToken = sAlyToken;
    }
}
