package com.css.sdk.cservice.activity;

import android.accounts.Account;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.css.sdk.R;
import com.css.sdk.cservice.adapter.CssTextGridViewAdapter;
import com.css.sdk.cservice.adapter.RecommendQaAapter;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.base.FaqTagEnum;
import com.css.sdk.cservice.base.utils.DeviceInfoHelper;
import com.css.sdk.cservice.base.utils.LogUtils;
import com.css.sdk.cservice.base.utils.SoftHideKeyBoardUtil;
import com.css.sdk.cservice.base.utils.ToastUtil;
import com.css.sdk.cservice.base.utils.Utils;
import com.css.sdk.cservice.business.BusinessRequest;
import com.css.sdk.cservice.business.RequestCallback;
import com.css.sdk.cservice.data.FaqItem;
import com.css.sdk.cservice.userdata.GlobalData;
import com.css.sdk.cservice.utils.ContactValidator;

import java.util.List;

public class FeedBackActivity extends FeedBaseActivity implements RecommendQaAapter.RecommendQAItemClickListener, CssTextGridViewAdapter.GridViewItemClickListener {
    private TextView feedbackTv;
    private TextView feedbackHistoryTv;

    private EditText contactEt;

    private RelativeLayout recommendRl;
    private LinearLayout rootLl;
    private ImageView eye;
    private TextView recommendTv;
    private ListView recommendList;
    private TextView recommendQa;
    private TextView emptyRecommned;
    private LinearLayout recommendLl;//仅横屏布局有；

    // gridview for faqTag
    private GridView mGridView;
    private CssTextGridViewAdapter mGridAdapter;

    private boolean hasShow;
    private RecommendQaAapter recommendQaAapter;
    private List<FaqItem> faqList;
    private View recommendLine;

    // 推荐列表的loading
    private LinearLayout subLoadingView;
    public boolean mSubLoading;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        initView();
    }

    @Override
    public int getLayoutId() {
        return R.layout.css_activity_feed_back;
    }

    private void initView() {
        titleBack = findViewById(R.id.css_title_back);
        mGridView = findViewById(R.id.css_faqtag_gridView);
        mGridAdapter = new CssTextGridViewAdapter(this, 0, this);
        mGridView.setAdapter(mGridAdapter);

        titleBack.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });
        titleTv = findViewById(R.id.css_title_tv);
        titleTv.setText(R.string.css_string_feedback_question);
        subLoadingView = findViewById(R.id.listview_loading);
        rootLl = findViewById(R.id.css_feedback_root);

        feedbackTv = findViewById(R.id.css_feedback);
        feedbackHistoryTv = findViewById(R.id.css_feedback_history);

        contactEt = findViewById(R.id.css_et_contact);

        realTimeSearch(etFeedbackContent);
        recommendLine = findViewById(R.id.css_recommend_line);
        feedbackTv.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                feedBack();
            }
        });

        feedbackHistoryTv.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(FeedBackActivity.this, HistoryActivity.class);
                startActivity(intent);
            }
        });
        if (isLand) {
            recommendRl = findViewById(R.id.css_recommend_controller);
            recommendRl.setVisibility(View.VISIBLE);
            eye = findViewById(R.id.css_eye_land);
            recommendTv = findViewById(R.id.css_recommend_tv_land);
        } else {
            recommendRl = findViewById(R.id.css_recommend_rl);
            eye = findViewById(R.id.css_eye);
            recommendTv = findViewById(R.id.css_recommend_tv);
        }
        recommendLl = findViewById(R.id.css_recommend_ll);
        recommendList = findViewById(R.id.css_recommend_list);
        recommendQa = findViewById(R.id.css_recommend_qa);
        emptyRecommned = findViewById(R.id.css_empty_recommend);
        emptyRecommned.setVisibility(View.GONE);
        recommendQaAapter = new RecommendQaAapter(this, this);
        addFootView(recommendList);
        recommendList.setAdapter(recommendQaAapter);
        checkSpHelper();
        hasShow = spHelper.getBooleanWithDefault(Constants.RECOMMENDED_QA_SHOW, true);
        recommendRl.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dealRecommend(!hasShow);
                hasShow = !hasShow;
                spHelper.putBoolean(Constants.RECOMMENDED_QA_SHOW, hasShow);
            }
        });
        selectedQaType = FaqTagEnum.ACCOUNT;
        // 显示推荐问题
        dealRecommend(hasShow);
        SoftHideKeyBoardUtil.assistActivity(rootLl, etFeedbackContent, contactEt);
        if (recommendLl != null) {
            int width = DeviceInfoHelper.getScreenWidth(this);
            if (width <= 800) {
                LinearLayout.LayoutParams params = (LinearLayout.LayoutParams) recommendQa.getLayoutParams();
                params.setMargins(15, 10, 120, 10);
                recommendQa.setLayoutParams(params);
//                dealTypeTvWidth();
            }

        } else {
            int height = DeviceInfoHelper.getScreenHeight(this);
            if (height <= 800) {
                ViewGroup.LayoutParams params = contentRl.getLayoutParams();
                if (getString(R.string.css_string_recommended_qa).contains(" ")) {
                    params.height = 80;
                } else {
                    params.height = 110;
                }

                contentRl.setLayoutParams(params);
            }
        }
//        dealTypeTvHeight();
    }

    private void addFootView(ListView recommendList) {
        View footView = View.inflate(this, R.layout.css_recommend_qa_list_foot, null);
        footView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                //  带着tag 到新的activity中
                Intent intent = new Intent(FeedBackActivity.this, ReommendListActivity.class);
                intent.putExtra(Constants.KEY_FAQ_TAG, selectedQaType.getId());
                startActivity(intent);
            }
        });
        recommendList.addFooterView(footView);
    }

    private void realTimeSearch(EditText contactEt) {

        contactEt.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {

            }

            @Override
            public void afterTextChanged(Editable s) {
                //文字改变时进行查询
                if (!TextUtils.isEmpty(s.toString().trim())) {
                    getFaqListMatch(s.toString().trim());
                } else {
                    getFaqListMatch("");
                }
            }
        });
    }

    private void dealRecommend(boolean show) {
        if (show) {
            recommendTv.setText(R.string.css_string_hide_recommended_qa);
            recommendLine.setVisibility(View.VISIBLE);
            recommendTv.setTextColor(getResources().getColor(R.color.css_color_gray));
            eye.setImageDrawable(Utils.getDrawable(FeedBackActivity.this, R.drawable.css_eye_close));
            if (recommendLl != null) {
                recommendLl.setVisibility(View.VISIBLE);
            }

            if (faqList != null && faqList.isEmpty()) {
                recommendList.setVisibility(View.GONE);
                emptyRecommned.setVisibility(View.VISIBLE);
            } else {
                recommendList.setVisibility(View.VISIBLE);
                emptyRecommned.setVisibility(View.GONE);
            }
            recommendQa.setVisibility(View.VISIBLE);
            String lastType = spHelper.getString(Constants.LAST_REQUEST_RECOMMEND_QA_LIST_TYPE);
            if (lastType == null || faqList == null || !lastType.equals(selectedQaType)) {
                changeRecommendList();
            }
        } else {
            recommendLine.setVisibility(View.GONE);
            recommendTv.setText(R.string.css_string_show_recommended_qa);
            recommendTv.setTextColor(getResources().getColor(R.color.css_color_btn_blue));
            eye.setImageDrawable(Utils.getDrawable(FeedBackActivity.this, R.drawable.css_eye_open));
            if (recommendLl != null) {
                recommendLl.setVisibility(View.GONE);
            } else {
                recommendList.setVisibility(View.GONE);
                emptyRecommned.setVisibility(View.GONE);
            }
            recommendQa.setVisibility(View.GONE);
//            dealTypeTvHeight();
        }
    }


    private void changeRecommendList() {
//        if (mLoading || !hasShow) {
//            return;
//        }
//        getFaqList();
        getFaqListMatch("");
    }

    @Deprecated
    private void getFaqList() {
        showSubLoading();
        final String type = selectedQaType.getTag();
        BusinessRequest.getFaqList(type, new RequestCallback<List<FaqItem>>() {
            @Override
            public void onSuccess(final List<FaqItem> result) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        hideSubLoading();
                        spHelper.putString(Constants.LAST_REQUEST_RECOMMEND_QA_LIST_TYPE, type);
                        faqList = result;
                        if (result.isEmpty()) {
                            emptyRecommned.setVisibility(View.VISIBLE);
                            recommendList.setVisibility(View.GONE);
                            return;
                        }
                        emptyRecommned.setVisibility(View.GONE);
                        recommendList.setVisibility(View.VISIBLE);
                        if (hasShow) {
                            recommendQaAapter.bindData(result);
                        }
                    }
                });
            }

            @Override
            public void onFail(String msg, int code) {
                hideLoading();
                showError(code);
            }
        });
    }

    private void feedBack() {
        if (isContentEmpty()) {
            return;
        }
        if (mLoading) {
            return;
        }
        String contact = contactEt.getText().toString().trim();
        if (!contact.isEmpty()) {
            if (!ContactValidator.checkContact(contact)) {
                ToastUtil.showToastTip(getApplicationContext(), R.string.css_string_contact_error, false);
                return;
            }
        }
        showLoading();
        BusinessRequest.feedBackN(this, "", picNames, videoNames, cancelPics, selectedQaType.getTag(), contact
                , etFeedbackContent.getText().toString().trim(),
                new RequestCallback<String>() {
                    @Override
                    public void onSuccess(String result) {
                        runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                hideLoading();
                                startActivity(new Intent(FeedBackActivity.this, HistoryActivity.class));
//                                spHelper.putString(Constants.LAST_QA_TYPE, selectedQaType.getTag());
                                contactEt.setText("");
                                clearData();
                                finish();
                            }
                        });
                    }

                    @Override
                    public void onFail(String msg, int code) {
                        hideLoading();
                        showError(code);
                    }
                });
    }

    @Override
    protected void onDestroy() {
//        ImageLoader.getInstance().stop();
        if (GlobalData.getIsSensorLand()) {
            setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR_LANDSCAPE);
        }
        getWindow().getDecorView().findViewById(android.R.id.content).setPadding(0, 0, 0, 0);
        super.onDestroy();
    }

    private void getFaqListMatch(String content) {
        showSubLoading();
        BusinessRequest.getFaqMatchList(content, new RequestCallback<List<FaqItem>>() {
            @Override
            public void onSuccess(final List<FaqItem> result) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        if (result.isEmpty()) {
//                            changeRecommendList();
                            return;
                        }
                        faqList = result;
                        emptyRecommned.setVisibility(View.GONE);
                        recommendList.setVisibility(View.VISIBLE);
                        if (hasShow) {
                            recommendQaAapter.bindData(result);
                        }
                        hideSubLoading();
                    }
                });
            }

            @Override
            public void onFail(String msg, int code) {
                hideLoading();
                showError(code);
            }
        });
    }

    /**
     * 显示下方推荐类别的loading
     */
    public void showSubLoading() {
        recommendRl.setClickable(false);
        mSubLoading = true;
//        subLoadingView.setVisibility(View.VISIBLE);
    }

    public void hideSubLoading() {
        recommendRl.setClickable(true);
        mSubLoading = false;
//        subLoadingView.setVisibility(View.GONE);
    }

    /**
     * 显示整个页面的loading
     */
    @Override
    public void showLoading() {
        super.showLoading();
    }

    @Override
    public void hideLoading() {
        super.hideLoading();
    }

    @Override
    public void onItemClick(int position, FaqItem faqItem) {
        Intent i = new Intent(FeedBackActivity.this, RecommendDetailActvity.class);
        i.putExtra(Constants.KEY_RECOMMEND_ID, faqItem.id);
        startActivity(i);
    }

    @Override
    public void onGridItemClick(int id) {
        selectedQaType = getFaqEnumById(id);
//        changeRecommendList();
    }

}
