package com.css.sdk.cservice.activity;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.view.View;
import android.view.inputmethod.InputMethodManager;

import com.css.sdk.cservice.base.CSSErrors;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.base.FaqTagEnum;
import com.css.sdk.cservice.base.utils.LogUtils;
import com.css.sdk.cservice.base.utils.SpHelper;
import com.css.sdk.cservice.base.utils.ToastUtil;
import com.css.sdk.cservice.data.FaqItem;
import com.css.sdk.cservice.userdata.GlobalData;
import com.css.sdk.cservice.utils.CutoutUtil;
import com.css.sdk.cservice.utils.StatusNavUtils;

import java.util.ArrayList;
import java.util.List;

public class BaseActivity extends AppCompatActivity {
    public boolean isLand;
    private int screenType;
    public SpHelper spHelper;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        checkSpHelper();
        screenType = GlobalData.getScreenType();
        int orientation = getResources().getConfiguration().orientation;
        if (orientation == Configuration.ORIENTATION_LANDSCAPE) {
            isLand = true;
        }
//        if (screenType == Constants.SCREEN_TYPE_REVERSE_LAND) {
//            isLand = true;
//            setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_REVERSE_LANDSCAPE);
//        } else if (screenType == Constants.SCREEN_TYPE_LAND) {
//            isLand = true;
//            setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
//        } else {
//            isLand = false;
//            setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
//        }
        StatusNavUtils.setStatusNavBar(this, screenType);
        if (CutoutUtil.hasNotchScreen(this) && isLand) {
            CutoutUtil.useNotch(this, screenType);
        }
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        if (newConfig.orientation == Configuration.ORIENTATION_PORTRAIT && isLand) {
            if (screenType == Constants.SCREEN_TYPE_LAND) {
                setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
            } else if (screenType == Constants.SCREEN_TYPE_REVERSE_LAND) {
                setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_REVERSE_LANDSCAPE);
            }
        }
        if (newConfig.orientation == Configuration.ORIENTATION_LANDSCAPE && !isLand) {
            setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
        }
        super.onConfigurationChanged(newConfig);
    }

    @Override
    protected void onPause() {
        super.onPause();
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    public void checkSpHelper() {
        if (spHelper == null) {
            spHelper = new SpHelper(this, Constants.SP_NAME);
        }
    }

    /**
     * 隐藏软键盘(只适用于Activity，不适用于Fragment)
     */
    public void hideSoftKeyboard() {
        View view = getCurrentFocus();
        if (view != null) {
            InputMethodManager inputMethodManager = (InputMethodManager) getSystemService(Activity.INPUT_METHOD_SERVICE);
            inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), InputMethodManager.HIDE_NOT_ALWAYS);
        }
    }

    protected FaqTagEnum getFaqEnumByTag(String type) {
        for (int i = 0; i < FaqTagEnum.values().length; i++) {
            if (type.equals(FaqTagEnum.values()[i].getTag())) {
                return FaqTagEnum.values()[i];
            }
        }
        return FaqTagEnum.ACCOUNT;
    }

    protected FaqTagEnum getFaqEnumById(int faqTagId) {
        for (int i = 0; i < FaqTagEnum.values().length; i++) {
            if (faqTagId == FaqTagEnum.values()[i].getId()) {
                return FaqTagEnum.values()[i];
            }
        }
        return FaqTagEnum.ACCOUNT;
    }

    protected void showError(final int code) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                ToastUtil.showToastTip(getApplicationContext(), CSSErrors.getErrorMessage(code), false);
            }
        });
    }

}
