#!/usr/local/bin/perl
$TEST_CA_PREFIX="java com.claymoresystems.cert.CertRequest ";
$TEST_CA_LENGTH="1024";

sub test_ca {
  $certcertctr=0;

  foreach $t ("RSA", "DSA"){
    &test_x509($t);
    &test_spkac($t);
    &test_pkcs10($t);
  }
}

sub test_pkcs10 {
  local($type)=@_;
  unlink("pkcs10.pem");

  local($comm)="$TEST_CA_PREFIX $TEST_CA_LENGTH $type PKCS10 EKR$type$certctr$$ < PASSWORD > pkcs10.pem ";
  print "comMAND $comm\n";
  system("$comm");
  open(IN,"openssl ca -batch -config openssl.cnf -in pkcs10.pem|");
  while(<IN>){
    print;
    &check_error($_);
  }
  $certctr++;
}

sub test_spkac {
  local($type)=@_;
  unlink("spkac");

  local($comm)="$TEST_CA_PREFIX $TEST_CA_LENGTH $type SPKAC < PASSWORD > spkac.in";
  print "comMAND $comm\n";
  system($comm);
  open(IN,"spkac.in")||die("Die");
  open(OUT,">spkac");
  print OUT<<FOO;
C=US
O=RTFM
OU=Test
CN=EKR$type$certctr$$
FOO
  <IN>; # remove password
  print OUT "SPKAC=";

  while(<IN>){
    chop;
    print OUT $_;
  }
  print OUT "\n";
  close OUT;
  open(IN,"openssl ca -batch -config openssl.cnf -spkac spkac 2>&1 |");
  while(<IN>){
    print;
    &check_error($_);
  }
  $certctr++;
}

sub test_x509 {
  local($type)=@_;

  unlink("x509.pem");
  local($comm)="$TEST_CA_PREFIX $TEST_CA_LENGTH $type X509 EKR$type$certctr$$ < PASSWORD > x509.pem ";
  print "comMAND $comm\n";
  system("$comm");

  open(IN,"openssl verify -CAfile x509.pem x509.pem 2>&1 |");
  while(<IN>){
    print;
    &check_error($_);
  }
}

sub check_error {
  local($msg)=@_;

  die("Error: $msg") if $msg=~/error/i;
  die("Error: $msg") if $msg=~/failed/i;
}

1; # require fodder
