#!/usr/local/bin/perl
@CIPHERSUITES=("",
  "TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA",
  "TLS_DHE_DSS_WITH_DES_CBC_SHA",
  "TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA",
  "TLS_RSA_WITH_3DES_EDE_CBC_SHA",
  "TLS_RSA_WITH_DES_CBC_SHA",
  "TLS_RSA_WITH_RC4_128_MD5",
  "TLS_RSA_WITH_RC4_128_SHA",
  "TLS_RSA_EXPORT_WITH_RC4_40_MD5",
  "TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5",
  "TLS_RSA_EXPORT_WITH_DES40_CBC_SHA",
  "TLS_RSA_WITH_NULL_MD5",
  "TLS_RSA_WITH_NULL_SHA",
);

sub self {
  $GLOBAL_FLAGS="-s";
  &_self;
  $GLOBAL_FLAGS="";
  &_self;
}

sub _self {
  &self_success(0,0,5);
  &self_success(0,"-C",1);
  &self_success(0,"-c",5);
  &self_wrong_keys;
  &self_wrong_root;
  &self_bad_cert;
}

sub self_success {
  local($extra_client_flags,$extra_server_flags,$iteration_count)=@_;
  
  $extra_client_flags.=" $GLOBAL_FLAGS";

  # First try each cipher suite to make sure they all work 
  print "Self tests\n";

  print "Testing success cases\n";
  for($i=0; $i<=$#CIPHERSUITES; $i++) {
    $cs=$CIPHERSUITES[$i];
    
    
    if(($cs eq "")  || $cs=~/RSA/){
      &loadRSAKeys;
    }
    if($cs=~/DSS/){
      &loadDSSKeys;
    }

    &debug("Trying cipher suite $cs");
    $ADDITIONAL.=" $extra_server_flags" if $extra_server_flags;
    $ADDITIONAL_CLIENT=$extra_client_flags?$extra_client_flags:"";
    &execute_server($ROOT,$cs,$SERVER,$iteration_count,$ADDITIONAL);
    $cli_err=&execute_client($ROOT,$cs,$CLIENT,$iteration_count,"XXXX",
			     $ADDITIONAL_CLIENT);
    $ser_err=&cleanup_server;
    die("Client error: $cli_err") if $cli_err;
    die("Server error: $ser_err") if $ser_err;
  }
}

sub self_wrong_keys {
  printf "Testing with wrong keying material\n";
  for($i=0; $i<=$#CIPHERSUITES; $i++) {
    $cs=$CIPHERSUITES[$i];
    
    next unless $cs;

    if($cs=~/RSA/){
      &loadDSSKeys;
    }
    if($cs=~/DSS/){
      &loadRSAKeys;
    }

    &debug("Trying cipher suite $cs");

    &execute_server($ROOT,$cs,$SERVER,5,$ADDITIONAL);
    $cli_err=&execute_client($ROOT,$cs,$CLIENT,5,"XXXX",$GLOBAL_FLAGS);
    die("Error: Client should have failed") unless $cli_err;
    $ser_err=&cleanup_server;
    die("Error: Server should have failed") unless $ser_err;
  }
}

sub self_wrong_root {
  printf "Testing with wrong root\n";
  $cs=$CIPHERSUITES[0];
  &loadRSAKeys;
  $ROOT="rsa-root-other.pem";

  &execute_server($ROOT,$cs,$SERVER,5,$ADDITIONAL);
  $cli_err=&execute_client($ROOT,$cs,$CLIENT,5,"XXXX",$GLOBAL_FLAGS);
  die("Error: Client should have failed") unless $cli_err;
  $ser_err=&cleanup_server;
}

sub self_bad_cert {
  printf "Testing with bad certificate\n";
  &loadRSAKeys;
  $SERVER="rsa-broken.pem";

  &execute_server($ROOT,"",$SERVER,5,$ADDITIONAL);
  $cli_err=&execute_client($ROOT,"",$CLIENT,5,"XXXX",$GLOBAL_FLAGS);
  die("Error: Client should have failed") unless $cli_err;
  $ser_err=&cleanup_server;

  &loadDSSKeys;
  $SERVER="dsa-broken.pem";

  &execute_server($ROOT,"",$SERVER,5,$ADDITIONAL);
  $cli_err=&execute_client($ROOT,"",$CLIENT,5,"XXXX","");
  die("Error: Client should have failed") unless $cli_err;
  $ser_err=&cleanup_server;

}

sub loadDSSKeys {
      $ROOT="dsa-root.pem";
      $SERVER="dsa-server.pem";
      $CLIENT="dsa-client.pem";
      $ADDITIONAL="-D dh1024.pem";
      $CIPHER="TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA";
    }

sub loadRSAKeys {
      $ROOT="rsa-root.pem";
      $SERVER="rsa-server.pem";
      $CLIENT="rsa-client.pem";
      $ADDITIONAL="";
      $CIPHER="TLS_RSA_WITH_3DES_EDE_CBC_SHA";
    }

1; # require fodder
		   
	

