#!/usr/local/bin/perl5
require 'openssl.pl';

sub openssl_compat {
  $GLOBAL_FLAGS="-s";
  $OPENSSL_GLOBAL_FLAGS="-ssl3";
  &_openssl_compat;
  $GLOBAL_FLAGS="";
  $OPENSSL_GLOBAL_FLAGS="";
  &_openssl_compat;
}

sub _openssl_compat {
  for($i=0; $i<=$#CIPHERSUITES; $i++) {
    $cs=$CIPHERSUITES[$i];
    
    next if $cs=~/NULL/; # Openssl doesn't support NULL by default
    if(($cs eq "")  || $cs=~/RSA/){
      &loadRSAKeys;
    }
    if($cs=~/DSS/){
      &loadDSSKeys;
    }

    &debug("Trying cipher suite $cs");
    openssl_compat_sub($cs);
  }
}

sub openssl_compat_sub {
  local($ciphersuite)=@_;
  
  printf("OpenSSL compatibility tests: ciphersuite $ciphersuite\n");
  # First test us as a server with OpenSSL as the client
  &execute_server($ROOT,$ciphersuite,$SERVER,1,$ADDITIONAL);
  $cli_err=&openssl_execute_client($CLIENT);
  $ser_err=&cleanup_server;

  die("Server error: $ser_err\nClient Output $cli_err") if $ser_err;
  die("Client error: $cli_err\nServer Output $ser_err") if $cli_err;

  # Now as a client against an OpenSSL server
  &openssl_execute_server($SERVER,0);
  $cli_err=&execute_client($ROOT,$ciphersuite,$CLIENT,1,"XXX","-u $GLOBAL_FLAGS");
  $ser_err=&openssl_cleanup_server;
  die("Server error: $ser_err\nClient Output $cli_err") if $ser_err;
  die("Failed to detect server lack of close_notify") unless $cli_err;
  die("Client error: $cli_err\nServer Output $ser_err") unless $cli_err=~/Short read/;

  # Now with client auth
  &openssl_execute_server($SERVER,1);
  $cli_err=&execute_client($ROOT,$ciphersuite,$CLIENT,1,"XXX","-u $GLOBAL_FLAGS");
  $ser_err=&openssl_cleanup_server;
  die("Server error: $ser_err\nClient Output $cli_err") if $ser_err;
  die("Failed to detect server lack of close_notify") unless $cli_err;
  die("Client error: $cli_err\nServer Output $ser_err") unless $cli_err=~/Short read/;
}

1;# require fodder
