/*
 * Decompiled with CFR 0.152.
 */
package com.csfrequency.firebase.devicestore;

import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.v4.app.NotificationManagerCompat;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.FieldValue;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;
import java.util.HashMap;
import java.util.Map;

public class FirebaseDeviceStore {
    private static final String BLUETOOTH_PERMISSION = "android.permission.BLUETOOTH";
    private static final String DEFAULT_COLLECTION_PATH = "user-devices";
    private static final String DEVICE_ID_FIELD = "deviceId";
    private static final String DEVICES_FIELD = "devices";
    private static final String FCM_TOKEN_FIELD = "fcmToken";
    private static final String NAME_FIELD = "name";
    private static final String OS_FIELD = "os";
    private static final String TAG = "FirebaseDeviceStore";
    private static final String TYPE_FIELD = "type";
    private static final String USER_ID_FIELD = "userId";
    private final FirebaseAuth auth;
    private final String collectionPath;
    private final Context context;
    private final FirebaseFirestore firestore;
    private final FirebaseInstanceId instanceId;
    private FirebaseAuth.AuthStateListener authStateListener;
    private String currentToken = null;
    private FirebaseUser currentUser = null;
    private boolean subscribed = false;

    public FirebaseDeviceStore(Context context, FirebaseApp app) {
        this(context, app, DEFAULT_COLLECTION_PATH);
    }

    public FirebaseDeviceStore(Context context, FirebaseApp app, String collectionPath) {
        this.auth = FirebaseAuth.getInstance((FirebaseApp)app);
        this.collectionPath = collectionPath;
        this.context = context;
        this.firestore = FirebaseFirestore.getInstance((FirebaseApp)app);
        this.instanceId = FirebaseInstanceId.getInstance((FirebaseApp)app);
        LocalBroadcastManager.getInstance((Context)context).registerReceiver((BroadcastReceiver)new TokenReceiver(), new IntentFilter("onNewToken"));
    }

    public Task<Void> signOut() {
        if (this.currentUser != null && this.currentToken != null) {
            String uid = this.currentUser.getUid();
            this.currentUser = null;
            return this.deleteDevice(uid);
        }
        this.currentUser = null;
        return Tasks.forResult(null);
    }

    public void subscribe() {
        if (this.subscribed) {
            return;
        }
        if (!NotificationManagerCompat.from((Context)this.context).areNotificationsEnabled()) {
            throw new RuntimeException("Notifications are not enabled");
        }
        this.subscribed = true;
        this.currentUser = this.auth.getCurrentUser();
        this.instanceId.getInstanceId().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<InstanceIdResult>(){

            public void onComplete(@NonNull Task<InstanceIdResult> task) {
                if (task.isSuccessful()) {
                    FirebaseDeviceStore.this.currentToken = ((InstanceIdResult)task.getResult()).getToken();
                    if (FirebaseDeviceStore.this.currentToken != null && FirebaseDeviceStore.this.currentUser != null) {
                        FirebaseDeviceStore.this.updateDevice(FirebaseDeviceStore.this.currentUser.getUid(), FirebaseDeviceStore.this.currentToken);
                    }
                } else {
                    Log.w((String)FirebaseDeviceStore.TAG, (String)"Failed to load FCM token", (Throwable)task.getException());
                }
            }
        });
        this.authStateListener = new FirebaseAuth.AuthStateListener(){

            public void onAuthStateChanged(@NonNull FirebaseAuth firebaseAuth) {
                FirebaseUser authUser = firebaseAuth.getCurrentUser();
                if (authUser != null && FirebaseDeviceStore.this.currentUser == null) {
                    FirebaseDeviceStore.this.currentUser = authUser;
                    if (FirebaseDeviceStore.this.currentToken != null) {
                        FirebaseDeviceStore.this.updateDevice(FirebaseDeviceStore.this.currentUser.getUid(), FirebaseDeviceStore.this.currentToken);
                    }
                } else if (authUser == null && FirebaseDeviceStore.this.currentUser != null) {
                    Log.w((String)FirebaseDeviceStore.TAG, (String)"You need to call the `logout` method on the DeviceStore before logging out the user");
                    FirebaseDeviceStore.this.currentUser = authUser;
                }
                assert (FirebaseDeviceStore.this.currentUser == authUser);
            }
        };
        this.auth.addAuthStateListener(this.authStateListener);
    }

    public void unsubscribe() {
        if (this.authStateListener != null) {
            this.auth.removeAuthStateListener(this.authStateListener);
            this.authStateListener = null;
        }
        this.currentToken = null;
        this.currentUser = null;
        this.subscribed = false;
    }

    private Task<Void> deleteDevice(String userId) {
        final DocumentReference docRef = this.userRef(userId);
        return docRef.get().continueWithTask((Continuation)new Continuation<DocumentSnapshot, Task<Void>>(){

            public Task<Void> then(@NonNull Task<DocumentSnapshot> task) throws Exception {
                if (task.isSuccessful()) {
                    if (((DocumentSnapshot)task.getResult()).exists()) {
                        return docRef.update(FieldPath.of((String[])new String[]{FirebaseDeviceStore.DEVICES_FIELD, FirebaseDeviceStore.this.getDeviceId()}), (Object)FieldValue.delete(), new Object[0]);
                    }
                    return Tasks.forResult(null);
                }
                return Tasks.forException((Exception)task.getException());
            }
        });
    }

    private Task<Void> updateDevice(final String userId, final String token) {
        final DocumentReference docRef = this.userRef(userId);
        return docRef.get().continueWithTask((Continuation)new Continuation<DocumentSnapshot, Task<Void>>(){

            public Task<Void> then(@NonNull Task<DocumentSnapshot> task) throws Exception {
                if (task.isSuccessful()) {
                    if (((DocumentSnapshot)task.getResult()).exists()) {
                        String deviceId = FirebaseDeviceStore.this.getDeviceId();
                        return docRef.update(FieldPath.of((String[])new String[]{FirebaseDeviceStore.DEVICES_FIELD, deviceId}), (Object)FirebaseDeviceStore.this.createDevice(deviceId, token), new Object[0]);
                    }
                    return docRef.set((Object)FirebaseDeviceStore.this.createUserDevices(userId, token));
                }
                return Tasks.forException((Exception)task.getException());
            }
        });
    }

    private Map<String, String> createDevice(String deviceId, String token) {
        HashMap<String, String> device = new HashMap<String, String>();
        device.put(DEVICE_ID_FIELD, deviceId);
        device.put(FCM_TOKEN_FIELD, token);
        device.put(NAME_FIELD, this.getDeviceName());
        device.put(OS_FIELD, this.getOS());
        device.put(TYPE_FIELD, "Android");
        return device;
    }

    private Map<String, Object> createUserDevices(String userId, String token) {
        HashMap<String, Object> userDevices = new HashMap<String, Object>();
        HashMap<String, Map<String, String>> devices = new HashMap<String, Map<String, String>>();
        if (token != null) {
            String deviceId = this.getDeviceId();
            devices.put(deviceId, this.createDevice(deviceId, token));
        }
        userDevices.put(DEVICES_FIELD, devices);
        userDevices.put(USER_ID_FIELD, userId);
        return userDevices;
    }

    private String getDeviceId() {
        return Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"android_id");
    }

    private String getDeviceName() {
        int res = this.context.checkCallingOrSelfPermission(BLUETOOTH_PERMISSION);
        if (res == 0) {
            try {
                BluetoothAdapter myDevice = BluetoothAdapter.getDefaultAdapter();
                if (myDevice != null) {
                    return myDevice.getName();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "Unknown";
    }

    private String getOS() {
        return "Android " + Build.VERSION.RELEASE;
    }

    private DocumentReference userRef(String userId) {
        Preconditions.checkNotNull((Object)userId);
        return this.firestore.collection(this.collectionPath).document(userId);
    }

    private class TokenReceiver
    extends BroadcastReceiver {
        private TokenReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (!FirebaseDeviceStore.this.subscribed) {
                return;
            }
            String token = intent.getStringExtra("token");
            if (FirebaseDeviceStore.this.currentUser == null) {
                FirebaseDeviceStore.this.currentToken = token;
                return;
            }
            if (token == null && FirebaseDeviceStore.this.currentToken != null || !token.equals(FirebaseDeviceStore.this.currentToken)) {
                FirebaseDeviceStore.this.updateDevice(FirebaseDeviceStore.this.currentUser.getUid(), token);
                FirebaseDeviceStore.this.currentToken = token;
            }
        }
    }
}

