/*
 * Decompiled with CFR 0.152.
 */
package com.rahul.media.imagemodule.adapter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.v7.widget.RecyclerView;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.rahul.media.R;
import com.rahul.media.imagemodule.ImageGalleryPickerActivity;
import com.rahul.media.model.Album;
import com.rahul.media.model.Define;
import com.rahul.media.utils.MediaSingleTon;
import com.rahul.media.utils.MediaUtility;
import com.rahul.media.utils.SquareImageView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ImageAlbumListAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private final int pickCount;
    private List<Album> albumList;
    private List<String> thumbList = new ArrayList<String>();

    public ImageAlbumListAdapter(List<Album> albumList, int pickCount) {
        this.albumList = albumList;
        this.pickCount = pickCount;
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.image_album_item, parent, false);
        return new ViewHolder(view);
    }

    public void setThumbList(List<String> thumbList) {
        this.thumbList = thumbList;
        this.notifyDataSetChanged();
    }

    public void onBindViewHolder(final ViewHolder holder, final int position) {
        String thumbPath = "";
        if (this.thumbList != null && this.thumbList.size() > position) {
            thumbPath = this.thumbList.get(position);
        }
        this.loadImage(thumbPath, holder.imgAlbum);
        holder.areaAlbum.setTag((Object)this.albumList.get(position));
        Album a = (Album)holder.areaAlbum.getTag();
        holder.albumNameTv.setText((CharSequence)this.albumList.get((int)position).bucketname);
        holder.albumCountTv.setText((CharSequence)Html.fromHtml((String)("<b><font color='#03A9F4'>" + a.counter + "</font></b><font color='#FFFFFF'> Media </font>")));
        holder.areaAlbum.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Album a = (Album)v.getTag();
                Intent i = new Intent(holder.areaAlbum.getContext(), ImageGalleryPickerActivity.class);
                i.putExtra("album", (Serializable)a);
                i.putExtra("album_title", ((Album)((ImageAlbumListAdapter)ImageAlbumListAdapter.this).albumList.get((int)position)).bucketname);
                i.putExtra("pickCount", ImageAlbumListAdapter.this.pickCount);
                ((Activity)holder.areaAlbum.getContext()).startActivityForResult(i, Define.ENTER_ALBUM_REQUEST_CODE);
            }
        });
    }

    private void loadImage(String thumbPath, SquareImageView imgAlbum) {
        Context mContext = imgAlbum.getContext();
        byte[] imageByte = MediaSingleTon.getInstance().getImageByte(thumbPath);
        if (imageByte != null) {
            Glide.with((Context)mContext).load(imageByte).apply(new RequestOptions().centerCrop()).into((ImageView)imgAlbum);
        } else {
            byte[] thumbnail = MediaUtility.getThumbnail(thumbPath);
            if (thumbnail != null) {
                MediaSingleTon.getInstance().putImageByte(thumbPath, thumbnail);
                Glide.with((Context)mContext).load(thumbnail).apply(new RequestOptions().centerCrop()).into((ImageView)imgAlbum);
            } else {
                Glide.with((Context)mContext).load(Uri.parse((String)("file://" + thumbPath))).apply(new RequestOptions().centerCrop().override(200, 200)).into((ImageView)imgAlbum);
            }
        }
    }

    public int getItemCount() {
        return this.albumList.size();
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        private SquareImageView imgAlbum;
        private TextView albumNameTv;
        private TextView albumCountTv;
        private LinearLayout areaAlbum;

        public ViewHolder(View view) {
            super(view);
            this.imgAlbum = (SquareImageView)view.findViewById(R.id.img_album);
            this.albumNameTv = (TextView)view.findViewById(R.id.album_name);
            this.albumCountTv = (TextView)view.findViewById(R.id.album_photos_count);
            this.areaAlbum = (LinearLayout)view.findViewById(R.id.area_album);
        }
    }
}

