/*
 * Decompiled with CFR 0.152.
 */
package com.cache;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Handler;
import android.util.Log;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.cache.BitmapMemoryCache;
import com.cache.FileCache;
import com.cache.MemoryCache;
import com.rahul.media.R;
import com.rahul.media.utils.MediaUtility;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ByteImageLoader {
    private final MemoryCache memoryCache = new MemoryCache();
    private BitmapMemoryCache bitmapMemoryCache = new BitmapMemoryCache();
    private FileCache fileCache;
    private Map<ImageView, String> imageViews = Collections.synchronizedMap(new WeakHashMap());
    private ExecutorService executorService;
    private Handler handler = new Handler();
    private int reqWidth = 100;
    private int reqHeight = 100;
    private final int stub_id = R.drawable.ic_empty_amoled;
    private static String PREFIX_BYTE = "byte_";
    private static String PREFIX_BITMAP = "bitmap_";

    public BitmapMemoryCache getBitmapMemoryCache() {
        return this.bitmapMemoryCache;
    }

    public ByteImageLoader(Context context) {
        this.fileCache = new FileCache(context);
        this.executorService = Executors.newFixedThreadPool(5);
    }

    public void DisplayImage(String url, ImageView imageView) {
        this.imageViews.put(imageView, url);
        byte[] imageByte = this.memoryCache.get(url);
        if (imageByte != null) {
            Log.i((String)"ByteImageLoader", (String)"Load from byte cache");
            Glide.with((Context)imageView.getContext()).load(imageByte).apply(new RequestOptions().centerCrop()).into(imageView);
        } else {
            Bitmap bitmap = this.bitmapMemoryCache.get(url);
            if (bitmap == null) {
                this.queuePhoto(url, imageView);
                imageView.setImageResource(this.stub_id);
            } else {
                Log.i((String)"ByteImageLoader", (String)"Load from bitmap cache");
                imageView.setImageBitmap(bitmap);
            }
        }
    }

    private void queuePhoto(String url, ImageView imageView) {
        PhotoToLoad p = new PhotoToLoad(url, imageView);
        this.executorService.submit(new PhotosLoader(p));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap getBitmap(String url) {
        File f = this.fileCache.getFile(url, PREFIX_BITMAP);
        Bitmap b = this.decodeFile(f);
        if (b != null) {
            Log.i((String)"ByteImageLoader", (String)("Read bitmap file from cache :- " + f.getName()));
            return b;
        }
        try {
            Bitmap bitmap = this.decodeFile(new File(url));
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(f);
                Log.i((String)"ByteImageLoader", (String)("Write bitmap file from cache :- " + f.getName()));
                bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)out);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return bitmap;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            if (ex instanceof OutOfMemoryError) {
                this.memoryCache.clear();
            }
            return null;
        }
    }

    private Bitmap decodeFile(File f) {
        try {
            BitmapFactory.Options o = new BitmapFactory.Options();
            o.inJustDecodeBounds = true;
            FileInputStream stream1 = new FileInputStream(f);
            BitmapFactory.decodeStream((InputStream)stream1, null, (BitmapFactory.Options)o);
            stream1.close();
            int REQUIRED_SIZE = this.reqWidth;
            int width_tmp = o.outWidth;
            int height_tmp = o.outHeight;
            int scale = 1;
            while (width_tmp / 2 >= REQUIRED_SIZE && height_tmp / 2 >= REQUIRED_SIZE) {
                width_tmp /= 2;
                height_tmp /= 2;
                scale *= 2;
            }
            BitmapFactory.Options o2 = new BitmapFactory.Options();
            o2.inSampleSize = scale;
            FileInputStream stream2 = new FileInputStream(f);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)stream2, null, (BitmapFactory.Options)o2);
            stream2.close();
            return bitmap;
        }
        catch (FileNotFoundException o) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getBitmapByte(String url) {
        File f = this.fileCache.getFile(url, PREFIX_BYTE);
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(f);
            byte[] fileContent = new byte[(int)f.length()];
            fin.read(fileContent);
            Log.i((String)"ByteImageLoader", (String)("Read byte file from cache :- " + f.getName()));
            byte[] byArray = fileContent;
            return byArray;
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found" + e);
        }
        catch (IOException ioe) {
            System.out.println("Exception while reading file " + ioe);
        }
        catch (Exception ioe) {
            System.out.println("Other File Exception while reading file " + ioe);
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (IOException ioe) {
                System.out.println("Error while closing stream: " + ioe);
            }
        }
        try {
            byte[] thumbnail = MediaUtility.getThumbnail(url);
            if (thumbnail != null) {
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(f));
                bos.write(thumbnail);
                bos.flush();
                bos.close();
                Log.i((String)"ByteImageLoader", (String)("Write byte to file in cache :- " + f.getName()));
            }
            return thumbnail;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            if (ex instanceof OutOfMemoryError) {
                this.memoryCache.clear();
                this.bitmapMemoryCache.clear();
            }
            return null;
        }
    }

    private boolean imageViewReused(PhotoToLoad photoToLoad) {
        String tag = this.imageViews.get(photoToLoad.imageView);
        return tag == null || !tag.equals(photoToLoad.url);
    }

    public void clearCache() {
        this.memoryCache.clear();
        this.bitmapMemoryCache.clear();
        this.fileCache.clear();
    }

    private class BitmapDisplayer
    implements Runnable {
        private Bitmap bitmap;
        byte[] byteBitmap;
        PhotoToLoad photoToLoad;

        BitmapDisplayer(byte[] byteBitmap, PhotoToLoad p) {
            this.byteBitmap = byteBitmap;
            this.photoToLoad = p;
        }

        BitmapDisplayer(Bitmap bitmap, PhotoToLoad p) {
            this.bitmap = bitmap;
            this.photoToLoad = p;
        }

        @Override
        public void run() {
            if (ByteImageLoader.this.imageViewReused(this.photoToLoad)) {
                return;
            }
            if (this.byteBitmap != null) {
                Log.i((String)"ByteImageLoader", (String)"Load from byte");
                Glide.with((Context)this.photoToLoad.imageView.getContext()).load(this.byteBitmap).apply(new RequestOptions().centerCrop()).into(this.photoToLoad.imageView);
            } else if (this.bitmap != null) {
                Log.i((String)"ByteImageLoader", (String)"Load from bitmap");
                this.photoToLoad.imageView.setImageBitmap(this.bitmap);
            } else {
                Log.i((String)"ByteImageLoader", (String)"Load from glide uri direct");
                Glide.with((Context)this.photoToLoad.imageView.getContext()).load(Uri.parse((String)("file://" + this.photoToLoad.url))).apply(new RequestOptions().centerCrop().override(200, 200)).into(this.photoToLoad.imageView);
            }
        }
    }

    private class PhotosLoader
    implements Runnable {
        PhotoToLoad photoToLoad;

        PhotosLoader(PhotoToLoad photoToLoad) {
            this.photoToLoad = photoToLoad;
        }

        @Override
        public void run() {
            try {
                if (ByteImageLoader.this.imageViewReused(this.photoToLoad)) {
                    return;
                }
                byte[] thumbnail = ByteImageLoader.this.getBitmapByte(this.photoToLoad.url);
                if (thumbnail != null) {
                    ByteImageLoader.this.memoryCache.put(this.photoToLoad.url, thumbnail);
                    BitmapDisplayer bd = new BitmapDisplayer(thumbnail, this.photoToLoad);
                    ByteImageLoader.this.handler.post((Runnable)bd);
                } else {
                    Bitmap bmp = ByteImageLoader.this.getBitmap(this.photoToLoad.url);
                    ByteImageLoader.this.bitmapMemoryCache.put(this.photoToLoad.url, bmp);
                    if (ByteImageLoader.this.imageViewReused(this.photoToLoad)) {
                        return;
                    }
                    BitmapDisplayer bd = new BitmapDisplayer(bmp, this.photoToLoad);
                    ByteImageLoader.this.handler.post((Runnable)bd);
                }
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }

    private class PhotoToLoad {
        String url;
        ImageView imageView;

        PhotoToLoad(String u, ImageView i) {
            this.url = u;
            this.imageView = i;
        }
    }
}

