/*
 * Decompiled with CFR 0.152.
 */
package com.rahul.media.videomodule.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.rahul.media.R;
import com.rahul.media.model.GalleryPhotoAlbum;
import java.util.ArrayList;

public abstract class VideoAlbumListAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private ArrayList<GalleryPhotoAlbum> albumList;
    Context mContext;

    public VideoAlbumListAdapter(Context mContext, ArrayList<GalleryPhotoAlbum> path) {
        this.albumList = path;
        this.mContext = mContext;
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.album_item, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(final ViewHolder holder, int position) {
        Glide.with((Context)this.mContext).load(this.albumList.get(position).getData()).asBitmap().diskCacheStrategy(DiskCacheStrategy.RESULT).priority(Priority.HIGH).centerCrop().error(R.drawable.ic_empty_amoled).placeholder(R.drawable.ic_empty_amoled).into(holder.imgAlbum);
        holder.areaAlbum.setTag((Object)this.albumList.get(position));
        holder.txtAlbum.setText((CharSequence)this.albumList.get(position).getBucketName());
        holder.txtAlbumCount.setText((CharSequence)Html.fromHtml((String)("<b><font color='#03A9F4'>" + this.albumList.get(position).getTotalCount() + "</font></b><font color='#FFFFFF'> Media </font>")));
        holder.view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                VideoAlbumListAdapter.this.onItemClick(holder);
            }
        });
    }

    public int getItemCount() {
        return this.albumList.size();
    }

    public abstract void onItemClick(ViewHolder var1);

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView imgAlbum;
        private TextView txtAlbum;
        private TextView txtAlbumCount;
        private LinearLayout areaAlbum;
        private View view;

        public ViewHolder(View view) {
            super(view);
            this.view = view;
            this.imgAlbum = (ImageView)view.findViewById(R.id.img_album);
            this.txtAlbum = (TextView)view.findViewById(R.id.album_name);
            this.txtAlbumCount = (TextView)view.findViewById(R.id.album_photos_count);
            this.areaAlbum = (LinearLayout)view.findViewById(R.id.area_album);
        }
    }
}

