/*
 * Decompiled with CFR 0.152.
 */
package com.rahul.media.utils;

import android.content.Context;
import android.graphics.BitmapFactory;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Environment;
import android.util.Log;
import com.rahul.media.activity.CameraPickActivity;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MediaUtility {
    public static String getUserImageDir(Context mContext) {
        return Environment.getExternalStorageDirectory().getAbsolutePath() + "/MultipleImageCache/data/" + mContext.getPackageName() + "/images";
    }

    public static File initializeImageLoader(Context mContext) {
        File cacheDir = new File(MediaUtility.getUserImageDir(mContext));
        if (!cacheDir.exists()) {
            cacheDir.mkdirs();
        }
        return cacheDir;
    }

    public static void CopyStream(InputStream is, OutputStream os) {
        int buffer_size = 1024;
        try {
            int count;
            byte[] bytes = new byte[1024];
            while ((count = is.read(bytes, 0, 1024)) != -1) {
                os.write(bytes, 0, count);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Uri createImageFile(Context mContext) throws IOException {
        File image = null;
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String imageFileName = "JPEG_" + timeStamp + "_";
        if ("mounted".equals(Environment.getExternalStorageState())) {
            File storageDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
            image = File.createTempFile(imageFileName, ".jpg", storageDir);
        } else {
            File storageDir = mContext.getFilesDir();
            image = File.createTempFile(imageFileName, ".jpg", storageDir);
        }
        Log.d((String)CameraPickActivity.class.getSimpleName(), (String)("file:" + image.getAbsolutePath()));
        return Uri.fromFile((File)image);
    }

    public static byte[] getThumbnail(String path) {
        ExifInterface exif;
        try {
            exif = new ExifInterface(path);
        }
        catch (IOException e) {
            return null;
        }
        byte[] imageData = exif.getThumbnail();
        if (imageData != null) {
            return imageData;
        }
        return null;
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int halfHeight = height / 2;
            int halfWidth = width / 2;
            while (halfHeight / inSampleSize > reqHeight && halfWidth / inSampleSize > reqWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }
}

