/*
 * Decompiled with CFR 0.152.
 */
package com.rahul.media.activity;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.media.ThumbnailUtils;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Toast;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.msupport.MSupport;
import com.msupport.MSupportConstants;
import com.nostra13.universalimageloader.core.ImageLoader;
import com.rahul.media.R;
import com.rahul.media.adapters.ImageListRecycleAdapter;
import com.rahul.media.adapters.VideoPreviewAdapter;
import com.rahul.media.model.CustomGallery;
import com.rahul.media.model.Define;
import com.rahul.media.model.VideoQuality;
import com.rahul.media.utils.ProcessGalleryFile;
import com.rahul.media.utils.ViewPagerSwipeLess;
import com.rahul.media.videomodule.VideoAlbumActivity;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class VideoPickActivity
extends AppCompatActivity {
    private static final int ACTION_REQUEST_VIDEO_FROM_CAMERA = 201;
    private static final int ACTION_REQUEST_VIDEO_FROM_GALLERY = 202;
    private AlertDialog alertDialog;
    private ViewPagerSwipeLess mPager;
    private HashMap<String, CustomGallery> dataT;
    private VideoPreviewAdapter adapter;
    private ImageListRecycleAdapter mImageListAdapter;
    private long videoSize;
    private int videoDuration;
    private int videoQuality = VideoQuality.HIGH_QUALITY.getQuality();
    private int pickCount;
    private boolean pickFromGallery;
    private ProgressDialog progressDialog;

    private void showAlertDialog(Context mContext, String text) {
        this.alertDialog = new AlertDialog.Builder(mContext).setMessage((CharSequence)text).setCancelable(false).setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                VideoPickActivity.this.alertDialog.dismiss();
            }
        }).create();
        this.alertDialog.show();
    }

    protected void onResume() {
        super.onResume();
        Fresco.initialize((Context)this);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_video_preview);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(toolbar);
        toolbar.setBackgroundColor(Define.ACTIONBAR_COLOR);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.progressDialog = new ProgressDialog((Context)this);
        this.progressDialog.setMessage((CharSequence)"Please wait ...");
        this.progressDialog.setCancelable(false);
        this.mPager = (ViewPagerSwipeLess)this.findViewById(R.id.pager);
        this.dataT = new HashMap();
        this.adapter = new VideoPreviewAdapter((Context)this, this.dataT);
        this.mPager.setAdapter(this.adapter);
        this.mImageListAdapter = new ImageListRecycleAdapter((Context)this, this.dataT);
        RecyclerView mRecycleView = (RecyclerView)this.findViewById(R.id.image_hlistview);
        mRecycleView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this, 0, false));
        mRecycleView.setAdapter((RecyclerView.Adapter)this.mImageListAdapter);
        this.mImageListAdapter.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                VideoPickActivity.this.mPager.setCurrentItem(position);
            }
        });
        try {
            this.videoSize = this.getIntent().getExtras().getLong("videoSize");
            this.videoDuration = (int)this.getIntent().getExtras().getLong("videoDuration");
            this.videoQuality = this.getIntent().getExtras().getInt("videoQuality");
            this.pickCount = this.getIntent().getIntExtra("pickCount", 1);
            this.pickFromGallery = this.getIntent().getBooleanExtra("from", false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.pickFromGallery) {
            Intent intent = new Intent((Context)this, VideoAlbumActivity.class);
            intent.putExtra("pickCount", this.pickCount);
            this.startActivityForResult(intent, 202);
        } else {
            this.openVideoFromCamera(false);
        }
    }

    private void openVideoFromCamera(boolean isPermission) {
        String[] permissionSet = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.CAMERA"};
        if (isPermission) {
            this.openVideoCamera();
        } else {
            boolean isCameraPermissionGranted = Build.VERSION.SDK_INT >= 23 ? MSupport.checkMultiplePermission((Activity)this, permissionSet, 124) : true;
            if (isCameraPermissionGranted) {
                this.openVideoCamera();
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        switch (requestCode) {
            case 124: {
                ArrayList<String> deniedPermissionList = new ArrayList<String>();
                boolean isAllPermissionGranted = true;
                for (int i = 0; i < grantResults.length; ++i) {
                    int results = grantResults[i];
                    String permission2 = permissions[i];
                    if (results == 0) continue;
                    isAllPermissionGranted = false;
                    deniedPermissionList.add(MSupportConstants.getPermissionRationaleMessage(permission2));
                }
                if (isAllPermissionGranted) {
                    if (this.pickFromGallery) break;
                    this.openVideoFromCamera(true);
                    break;
                }
                String message = "Requested Permission not granted";
                if (!deniedPermissionList.isEmpty()) {
                    message = "You need to grant access to " + (String)deniedPermissionList.get(0);
                    for (int i = 1; i < deniedPermissionList.size(); ++i) {
                        message = message + ", " + (String)deniedPermissionList.get(i);
                    }
                    message = message + " to access app features";
                }
                Toast.makeText((Context)this, (CharSequence)message, (int)0).show();
                this.finish();
            }
        }
    }

    private void openVideoCamera() {
        ContentValues values = new ContentValues();
        String fileName = System.currentTimeMillis() + ".mp4";
        values.put("title", fileName);
        values.put("mime_type", "video/mp4");
        try {
            Intent intent = new Intent("android.media.action.VIDEO_CAPTURE");
            intent.putExtra("android.intent.extra.videoQuality", this.videoQuality);
            if (this.videoSize != -1L) {
                intent.putExtra("android.intent.extra.sizeLimit", this.videoSize);
            }
            if (this.videoDuration != -1) {
                intent.putExtra("android.intent.extra.durationLimit", this.videoDuration);
            }
            this.startActivityForResult(intent, 201);
        }
        catch (Exception e) {
            e.printStackTrace();
            Toast.makeText((Context)this, (CharSequence)"SD-Card not available", (int)1).show();
        }
    }

    private void getBitmapFromPath(final ArrayList<String> stringArrayList) {
        this.progressDialog.show();
        try {
            Handler mHandler = new Handler();
            mHandler.post(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < stringArrayList.size(); ++i) {
                        CustomGallery item = new CustomGallery();
                        item.sdcardPath = (String)stringArrayList.get(i);
                        item.sdCardUri = Uri.parse((String)((String)stringArrayList.get(i)));
                        Bitmap bmp = null;
                        try {
                            bmp = ImageLoader.getInstance().getMemoryCache().get(Uri.fromFile((File)new File(item.sdcardPath)).toString() + "_");
                        }
                        catch (Exception e) {
                            Log.e((String)ProcessGalleryFile.class.getSimpleName(), (String)("" + e));
                        }
                        if (bmp == null) {
                            try {
                                bmp = ThumbnailUtils.createVideoThumbnail((String)item.sdcardPath, (int)1);
                                if (bmp != null) {
                                    ImageLoader.getInstance().getMemoryCache().put(Uri.fromFile((File)new File(item.sdcardPath)).toString() + "_", bmp);
                                }
                            }
                            catch (Exception e) {
                                Log.e((String)this.getClass().getSimpleName(), (String)"Exception when rotating thumbnail for gallery", (Throwable)e);
                            }
                            catch (OutOfMemoryError e) {
                                Log.e((String)ProcessGalleryFile.class.getSimpleName(), (String)("" + e));
                            }
                        }
                        VideoPickActivity.this.dataT.put(item.sdcardPath, item);
                    }
                    try {
                        VideoPickActivity.this.mImageListAdapter.customNotify(VideoPickActivity.this.dataT);
                        VideoPickActivity.this.adapter.customNotify(VideoPickActivity.this.dataT);
                        VideoPickActivity.this.progressDialog.dismiss();
                    }
                    catch (Exception e) {
                        VideoPickActivity.this.progressDialog.dismiss();
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            this.progressDialog.dismiss();
            e.printStackTrace();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            ArrayList allPath;
            ArrayList<String> pickedVideoList = new ArrayList<String>();
            if (this.pickCount == 1) {
                this.dataT.clear();
            }
            if (requestCode == 201) {
                String[] projection = new String[]{"_data"};
                Cursor cursor = this.getContentResolver().query(data.getData(), projection, null, null, null);
                if (cursor != null) {
                    int column_index_data = cursor.getColumnIndexOrThrow("_data");
                    cursor.moveToFirst();
                    pickedVideoList.add(cursor.getString(column_index_data));
                    cursor.close();
                }
            } else if (requestCode == 202 && (allPath = data.getStringArrayListExtra("all_path")) != null) {
                pickedVideoList.addAll(allPath);
            }
            if (!pickedVideoList.isEmpty()) {
                this.getBitmapFromPath(pickedVideoList);
            }
        } else if (this.dataT == null || this.dataT.size() == 0) {
            Intent data2 = new Intent();
            this.setResult(0, data2);
            this.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    private String getPath(Uri uri, Context context) {
        Cursor cursor;
        if (uri == null) {
            return null;
        }
        String[] projection = new String[]{"_data"};
        if (Build.VERSION.SDK_INT > 19) {
            String wholeID = DocumentsContract.getDocumentId((Uri)uri);
            String id2 = wholeID.split(":")[1];
            String sel = "_id=?";
            cursor = context.getContentResolver().query(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, projection, sel, new String[]{id2}, null);
        } else {
            cursor = context.getContentResolver().query(uri, projection, null, null, null);
        }
        String path = null;
        try {
            int column_index = cursor.getColumnIndex("_data");
            cursor.moveToFirst();
            path = cursor.getString(column_index);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return path;
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.menu_video_pick, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        String imagePath;
        CustomGallery customGallery;
        int id2 = item.getItemId();
        if (id2 == R.id.action_ok) {
            ArrayList<CustomGallery> mArrayList = new ArrayList<CustomGallery>(this.dataT.values());
            if (mArrayList.size() > 0) {
                ArrayList<String> allPath = new ArrayList<String>();
                for (int i = 0; i < mArrayList.size(); ++i) {
                    allPath.add(mArrayList.get((int)i).sdcardPath);
                }
                Intent data = new Intent().putStringArrayListExtra("all_path", allPath);
                this.setResult(-1, data);
                this.finish();
            } else {
                this.showAlertDialog((Context)this, "Please select a video.");
            }
        } else if (id2 == 16908332) {
            Intent data = new Intent();
            this.setResult(0, data);
            this.finish();
        } else if (id2 == R.id.action_pick) {
            if (this.pickFromGallery) {
                Intent intent = new Intent((Context)this, VideoAlbumActivity.class);
                intent.putExtra("pickCount", this.pickCount);
                this.startActivityForResult(intent, 202);
            } else {
                this.openVideoFromCamera(false);
            }
        } else if (id2 == R.id.delete && this.adapter != null && this.adapter.getCount() > 0 && (customGallery = this.dataT.remove(imagePath = this.mImageListAdapter.mItems.get((int)this.mPager.getCurrentItem()).sdcardPath)) != null) {
            this.mImageListAdapter.customNotify(this.dataT);
            this.adapter.customNotify(this.dataT);
        }
        return super.onOptionsItemSelected(item);
    }
}

