/*
 * Decompiled with CFR 0.152.
 */
package com.rahul.media.videomodule.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.rahul.media.R;
import com.rahul.media.model.Define;
import com.rahul.media.model.GalleryPhotoAlbum;
import java.util.ArrayList;

public abstract class VideoAlbumListAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private ArrayList<GalleryPhotoAlbum> albumList;
    Context mContext;

    public VideoAlbumListAdapter(Context mContext, ArrayList<GalleryPhotoAlbum> path) {
        this.albumList = path;
        this.mContext = mContext;
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.album_item, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(final ViewHolder holder, int position) {
        holder.imgAlbum.setVisibility(8);
        holder.areaAlbum.setTag((Object)this.albumList.get(position));
        holder.txtAlbum.setText((CharSequence)this.albumList.get(position).getBucketName());
        holder.txtAlbumCount.setText((CharSequence)(this.albumList.get(position).getTotalCount() + ""));
        holder.view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                VideoAlbumListAdapter.this.onItemClick(holder);
            }
        });
    }

    public int getItemCount() {
        return this.albumList.size();
    }

    public abstract void onItemClick(ViewHolder var1);

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView imgAlbum;
        private TextView txtAlbum;
        private TextView txtAlbumCount;
        private RelativeLayout areaAlbum;
        private View view;

        public ViewHolder(View view) {
            super(view);
            this.view = view;
            this.imgAlbum = (ImageView)view.findViewById(R.id.img_album);
            this.imgAlbum.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(Define.ALBUM_THUMBNAIL_SIZE, Define.ALBUM_THUMBNAIL_SIZE));
            this.txtAlbum = (TextView)view.findViewById(R.id.txt_album);
            this.txtAlbumCount = (TextView)view.findViewById(R.id.txt_album_count);
            this.areaAlbum = (RelativeLayout)view.findViewById(R.id.area_album);
        }
    }
}

