/*
 * Decompiled with CFR 0.152.
 */
package com.luminous.pick.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Environment;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CameraUtils {
    private static final String TAG = CameraUtils.class.getSimpleName();

    public static Uri createImageFile(Context mContext) throws IOException {
        File image = null;
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String imageFileName = "JPEG_" + timeStamp + "_";
        if ("mounted".equals(Environment.getExternalStorageState())) {
            File storageDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
            image = File.createTempFile(imageFileName, ".jpg", storageDir);
        } else {
            File storageDir = mContext.getFilesDir();
            image = File.createTempFile(imageFileName, ".jpg", storageDir);
        }
        Log.d((String)TAG, (String)("file:" + image.getAbsolutePath()));
        return Uri.fromFile((File)image);
    }

    public static String compressImage(String filePath, int outputQuality) {
        Bitmap scaledBitmap = null;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        Bitmap bmp = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        int actualHeight = options.outHeight;
        int actualWidth = options.outWidth;
        float maxHeight = 816.0f;
        float maxWidth = 612.0f;
        float imgRatio = actualWidth / actualHeight;
        float maxRatio = maxWidth / maxHeight;
        if ((float)actualHeight > maxHeight || (float)actualWidth > maxWidth) {
            if (imgRatio < maxRatio) {
                imgRatio = maxHeight / (float)actualHeight;
                actualWidth = (int)(imgRatio * (float)actualWidth);
                actualHeight = (int)maxHeight;
            } else if (imgRatio > maxRatio) {
                imgRatio = maxWidth / (float)actualWidth;
                actualHeight = (int)(imgRatio * (float)actualHeight);
                actualWidth = (int)maxWidth;
            } else {
                actualHeight = (int)maxHeight;
                actualWidth = (int)maxWidth;
            }
        }
        options.inSampleSize = CameraUtils.calculateInSampleSize(options, actualWidth, actualHeight);
        options.inJustDecodeBounds = false;
        options.inTempStorage = new byte[16384];
        try {
            bmp = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        }
        catch (OutOfMemoryError exception) {
            exception.printStackTrace();
        }
        try {
            scaledBitmap = Bitmap.createBitmap((int)actualWidth, (int)actualHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        catch (OutOfMemoryError exception) {
            exception.printStackTrace();
        }
        float ratioX = (float)actualWidth / (float)options.outWidth;
        float ratioY = (float)actualHeight / (float)options.outHeight;
        float middleX = (float)actualWidth / 2.0f;
        float middleY = (float)actualHeight / 2.0f;
        Matrix scaleMatrix = new Matrix();
        scaleMatrix.setScale(ratioX, ratioY, middleX, middleY);
        try {
            ExifInterface exif = new ExifInterface(filePath);
            int orientation = exif.getAttributeInt("Orientation", 0);
            Log.d((String)"EXIF", (String)("Exif: " + orientation));
            Matrix matrix = new Matrix();
            if (orientation == 6) {
                matrix.postRotate(90.0f);
                Log.d((String)"EXIF", (String)("Exif: " + orientation));
            } else if (orientation == 3) {
                matrix.postRotate(180.0f);
                Log.d((String)"EXIF", (String)("Exif: " + orientation));
            } else if (orientation == 8) {
                matrix.postRotate(270.0f);
                Log.d((String)"EXIF", (String)("Exif: " + orientation));
            }
            scaledBitmap = Bitmap.createBitmap((Bitmap)scaledBitmap, (int)0, (int)0, (int)scaledBitmap.getWidth(), (int)scaledBitmap.getHeight(), (Matrix)matrix, (boolean)true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(filePath);
            if (scaledBitmap != null) {
                scaledBitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)out);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return filePath;
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int widthRatio;
            int heightRatio = Math.round((float)height / (float)reqHeight);
            inSampleSize = heightRatio < (widthRatio = Math.round((float)width / (float)reqWidth)) ? heightRatio : widthRatio;
        }
        float totalPixels = width * height;
        float totalReqPixelsCap = reqWidth * reqHeight * 2;
        while (totalPixels / (float)(inSampleSize * inSampleSize) > totalReqPixelsCap) {
            ++inSampleSize;
        }
        return inSampleSize;
    }
}

