/*
 * Decompiled with CFR 0.152.
 */
package com.msupport;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v7.app.AlertDialog;
import android.support.v7.view.ContextThemeWrapper;
import com.luminous.pick.R;
import java.util.ArrayList;
import java.util.List;

public class MSupport {
    public static boolean isMSupportDevice(Context ctx) {
        return Build.VERSION.SDK_INT >= 23;
    }

    @TargetApi(value=23)
    public static boolean checkPermission(final Activity mActivity, final Fragment fragment, String[] permissionSet, final int requestCode) {
        if (MSupport.isMSupportDevice((Context)mActivity)) {
            final ArrayList<String> permissions = new ArrayList<String>();
            for (final String aPermissionSet : permissionSet) {
                int hasPermission = mActivity.checkSelfPermission(aPermissionSet);
                if (hasPermission == 0) continue;
                if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)mActivity, (String)aPermissionSet)) {
                    String msg = "";
                    if (aPermissionSet.equals("android.permission.CAMERA")) {
                        msg = mActivity.getString(R.string.camera_permission_rationale);
                    } else if (aPermissionSet.equals("android.permission.WRITE_EXTERNAL_STORAGE")) {
                        msg = mActivity.getString(R.string.storage_permission_rationale);
                    }
                    MSupport.showMessageOKCancel(mActivity, msg, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            permissions.add(aPermissionSet);
                            MSupport.requestPermissions(permissions, fragment, mActivity, requestCode);
                        }
                    });
                    continue;
                }
                permissions.add(aPermissionSet);
                MSupport.requestPermissions(permissions, fragment, mActivity, requestCode);
            }
            if (!permissions.isEmpty()) {
                if (fragment != null) {
                    fragment.requestPermissions(permissions.toArray(new String[permissions.size()]), requestCode);
                } else {
                    mActivity.requestPermissions(permissions.toArray(new String[permissions.size()]), requestCode);
                }
                return false;
            }
            return true;
        }
        return true;
    }

    @TargetApi(value=23)
    public static boolean checkPermissionWithRationale(final Activity mActivity, final Fragment fragment, final String permission, final int requestCode) {
        if (MSupport.isMSupportDevice((Context)mActivity)) {
            final ArrayList<String> permissions = new ArrayList<String>();
            int hasPermission = mActivity.checkSelfPermission(permission);
            if (hasPermission != 0) {
                if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)mActivity, (String)permission)) {
                    String msg = "";
                    if (requestCode == 123) {
                        msg = mActivity.getString(R.string.camera_permission_rationale);
                    } else if (requestCode == 2) {
                        msg = mActivity.getString(R.string.storage_permission_rationale);
                    }
                    MSupport.showMessageOKCancel(mActivity, msg, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            permissions.add(permission);
                            MSupport.requestPermissions(permissions, fragment, mActivity, requestCode);
                        }
                    });
                    return false;
                }
                permissions.add(permission);
                MSupport.requestPermissions(permissions, fragment, mActivity, requestCode);
                return false;
            }
            return true;
        }
        return true;
    }

    @TargetApi(value=23)
    private static boolean requestPermissions(List<String> permissions, Fragment fragment, Activity mActivity, int requestCode) {
        if (!permissions.isEmpty()) {
            if (fragment != null) {
                fragment.requestPermissions(permissions.toArray(new String[permissions.size()]), requestCode);
            } else {
                mActivity.requestPermissions(permissions.toArray(new String[permissions.size()]), requestCode);
            }
            return false;
        }
        return true;
    }

    private static void showMessageOKCancel(Activity activity, String message, DialogInterface.OnClickListener okListener) {
        new AlertDialog.Builder((Context)new ContextThemeWrapper((Context)activity, R.style.Theme_AppCompat_Dialog_Alert)).setMessage((CharSequence)message).setPositiveButton((CharSequence)activity.getString(R.string.btn_ok), okListener).create().show();
    }
}

