/*
 * Decompiled with CFR 0.152.
 */
package com.luminous.pick.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.view.ViewPager;
import android.text.InputFilter;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.luminous.pick.R;
import java.util.Locale;

public class PagerSlidingTabStrip
extends HorizontalScrollView {
    private static final int[] ATTRS = new int[]{16842901, 16842904};
    private final PageListener pageListener = new PageListener();
    public ViewPager.OnPageChangeListener delegatePageListener;
    private LinearLayout.LayoutParams defaultTabLayoutParams;
    private LinearLayout.LayoutParams expandedTabLayoutParams;
    private LinearLayout tabsContainer;
    private ViewPager pager;
    private int tabCount;
    private int currentPosition = 0;
    private float currentPositionOffset = 0.0f;
    private Paint rectPaint;
    private Paint dividerPaint;
    private int indicatorColor = -10066330;
    private int underlineColor = 0x1A000000;
    private int dividerColor = 0x1A000000;
    private boolean shouldExpand = false;
    private boolean textAllCaps = false;
    private int scrollOffset = 52;
    private int indicatorHeight = 2;
    private int underlineHeight = 1;
    private int dividerPadding = 12;
    private int tabPadding = 2;
    private int dividerWidth = 1;
    private int tabTextSize = 12;
    private int tabTextColor = -10066330;
    private Typeface tabTypeface = null;
    private int tabTypefaceStyle = 0;
    private int lastScrollX = 0;
    private int tabBackgroundResId = R.drawable.background_tab;
    private Locale locale;

    public PagerSlidingTabStrip(Context context) {
        this(context, null);
    }

    public PagerSlidingTabStrip(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PagerSlidingTabStrip(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setFillViewport(true);
        this.setWillNotDraw(false);
        this.tabsContainer = new LinearLayout(context);
        this.tabsContainer.setOrientation(0);
        this.tabsContainer.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.addView((View)this.tabsContainer);
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        this.scrollOffset = (int)TypedValue.applyDimension((int)1, (float)this.scrollOffset, (DisplayMetrics)dm);
        this.indicatorHeight = (int)TypedValue.applyDimension((int)1, (float)this.indicatorHeight, (DisplayMetrics)dm);
        this.underlineHeight = (int)TypedValue.applyDimension((int)1, (float)this.underlineHeight, (DisplayMetrics)dm);
        this.dividerPadding = (int)TypedValue.applyDimension((int)1, (float)this.dividerPadding, (DisplayMetrics)dm);
        this.tabPadding = (int)TypedValue.applyDimension((int)1, (float)this.tabPadding, (DisplayMetrics)dm);
        this.dividerWidth = (int)TypedValue.applyDimension((int)1, (float)this.dividerWidth, (DisplayMetrics)dm);
        this.tabTextSize = (int)TypedValue.applyDimension((int)2, (float)this.tabTextSize, (DisplayMetrics)dm);
        TypedArray a = context.obtainStyledAttributes(attrs, ATTRS);
        this.tabTextSize = a.getDimensionPixelSize(0, this.tabTextSize);
        this.tabTextColor = a.getColor(1, this.tabTextColor);
        a.recycle();
        a = context.obtainStyledAttributes(attrs, R.styleable.PagerSlidingTabStrip);
        this.indicatorColor = a.getColor(R.styleable.PagerSlidingTabStrip_pstsIndicatorColor, this.indicatorColor);
        this.underlineColor = a.getColor(R.styleable.PagerSlidingTabStrip_pstsUnderlineColor, this.underlineColor);
        this.dividerColor = a.getColor(R.styleable.PagerSlidingTabStrip_pstsDividerColor, this.dividerColor);
        this.indicatorHeight = a.getDimensionPixelSize(R.styleable.PagerSlidingTabStrip_pstsIndicatorHeight, this.indicatorHeight);
        this.underlineHeight = a.getDimensionPixelSize(R.styleable.PagerSlidingTabStrip_pstsUnderlineHeight, this.underlineHeight);
        this.dividerPadding = a.getDimensionPixelSize(R.styleable.PagerSlidingTabStrip_pstsDividerPadding, this.dividerPadding);
        this.tabPadding = a.getDimensionPixelSize(R.styleable.PagerSlidingTabStrip_pstsTabPaddingLeftRight, this.tabPadding);
        this.tabBackgroundResId = a.getResourceId(R.styleable.PagerSlidingTabStrip_pstsTabBackground, this.tabBackgroundResId);
        this.shouldExpand = a.getBoolean(R.styleable.PagerSlidingTabStrip_pstsShouldExpand, this.shouldExpand);
        this.scrollOffset = a.getDimensionPixelSize(R.styleable.PagerSlidingTabStrip_pstsScrollOffset, this.scrollOffset);
        this.textAllCaps = a.getBoolean(R.styleable.PagerSlidingTabStrip_pstsTextAllCaps, this.textAllCaps);
        a.recycle();
        this.rectPaint = new Paint();
        this.rectPaint.setAntiAlias(true);
        this.rectPaint.setStyle(Paint.Style.FILL);
        this.dividerPaint = new Paint();
        this.dividerPaint.setAntiAlias(true);
        this.dividerPaint.setStrokeWidth((float)this.dividerWidth);
        this.getMeasuredHeight();
        this.getHeight();
        int margin48 = (int)this.getResources().getDimension(R.dimen.margin_48);
        this.defaultTabLayoutParams = new LinearLayout.LayoutParams(margin48, margin48);
        this.defaultTabLayoutParams.setMargins(4, 2, 4, 2);
        this.expandedTabLayoutParams = new LinearLayout.LayoutParams(0, -1, 1.0f);
        if (this.locale == null) {
            this.locale = this.getResources().getConfiguration().locale;
        }
    }

    public ViewPager getViewPager() {
        return this.pager;
    }

    public void setViewPager(ViewPager pager) {
        this.pager = pager;
        if (pager.getAdapter() == null) {
            throw new IllegalStateException("ViewPager does not have adapter instance.");
        }
        pager.setOnPageChangeListener((ViewPager.OnPageChangeListener)this.pageListener);
        this.notifyDataSetChanged();
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.delegatePageListener = listener;
    }

    public void notifyDataSetChanged() {
        this.tabsContainer.removeAllViews();
        this.tabCount = this.pager.getAdapter().getCount();
        for (int i = 0; i < this.tabCount; ++i) {
            if (this.pager.getAdapter() instanceof IconTabProvider) {
                this.addIconTab(i, ((IconTabProvider)this.pager.getAdapter()).getPageIconResId(i));
                continue;
            }
            this.addTextTab(i, this.pager.getAdapter().getPageTitle(i).toString());
        }
        this.updateTabStyles();
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            @SuppressLint(value={"NewApi"})
            public void onGlobalLayout() {
                if (Build.VERSION.SDK_INT < 16) {
                    PagerSlidingTabStrip.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    PagerSlidingTabStrip.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                PagerSlidingTabStrip.this.currentPosition = PagerSlidingTabStrip.this.pager.getCurrentItem();
                PagerSlidingTabStrip.this.scrollToChild(PagerSlidingTabStrip.this.currentPosition, 0);
            }
        });
    }

    private void addTextTab(int position, String title) {
        TextView tab = new TextView(this.getContext());
        tab.setText((CharSequence)title);
        tab.setGravity(17);
        tab.setSingleLine();
        tab.setEllipsize(TextUtils.TruncateAt.END);
        InputFilter[] FilterArray = new InputFilter[]{new InputFilter.LengthFilter(10)};
        tab.setFilters(FilterArray);
        tab.setMaxWidth(300);
        this.addTab(position, (View)tab);
    }

    private void addIconTab(int position, String resId) {
        ImageView tab = (ImageView)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.image_strip_view, null);
        Drawable d = Drawable.createFromPath((String)resId);
        tab.setImageDrawable(d);
        this.addTab(position, (View)tab);
    }

    private void addTab(final int position, View tab) {
        tab.setFocusable(true);
        tab.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PagerSlidingTabStrip.this.pager.setCurrentItem(position);
            }
        });
        this.tabsContainer.addView(tab, position, (ViewGroup.LayoutParams)(this.shouldExpand ? this.expandedTabLayoutParams : this.defaultTabLayoutParams));
    }

    private void updateTabStyles() {
        for (int i = 0; i < this.tabCount; ++i) {
            View v = this.tabsContainer.getChildAt(i);
            v.setBackgroundResource(this.tabBackgroundResId);
            if (!(v instanceof TextView)) continue;
            TextView tab = (TextView)v;
            tab.setTextSize(0, (float)this.tabTextSize);
            tab.setTypeface(this.tabTypeface, this.tabTypefaceStyle);
            tab.setTextColor(this.tabTextColor);
            if (!this.textAllCaps) continue;
            if (Build.VERSION.SDK_INT >= 14) {
                tab.setAllCaps(true);
                continue;
            }
            tab.setText((CharSequence)tab.getText().toString().toUpperCase(this.locale));
        }
    }

    private void scrollToChild(int position, int offset) {
        if (this.tabCount == 0) {
            return;
        }
        int newScrollX = this.tabsContainer.getChildAt(position).getLeft() + offset;
        if (position > 0 || offset > 0) {
            newScrollX -= this.scrollOffset;
        }
        if (newScrollX != this.lastScrollX) {
            this.lastScrollX = newScrollX;
            this.scrollTo(newScrollX, 0);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isInEditMode() || this.tabCount == 0) {
            return;
        }
        int height = this.getHeight();
        int width = this.getWidth();
        this.rectPaint.setColor(this.indicatorColor);
        View currentTab = this.tabsContainer.getChildAt(this.currentPosition);
        float lineLeft = currentTab.getLeft();
        float lineRight = currentTab.getRight();
        float lineTop = currentTab.getTop();
        float lineBottom = currentTab.getBottom();
        if (this.currentPositionOffset > 0.0f && this.currentPosition < this.tabCount - 1) {
            View nextTab = this.tabsContainer.getChildAt(this.currentPosition + 1);
            float nextTabLeft = nextTab.getLeft();
            float nextTabRight = nextTab.getRight();
            lineLeft = this.currentPositionOffset * nextTabLeft + (1.0f - this.currentPositionOffset) * lineLeft;
            lineRight = this.currentPositionOffset * nextTabRight + (1.0f - this.currentPositionOffset) * lineRight;
        }
        float lineLeft2 = currentTab.getLeft();
        float lineRight2 = currentTab.getRight();
        float lineTop2 = currentTab.getTop();
        float lineBottom2 = currentTab.getBottom();
        canvas.drawRect(lineLeft2 - 4.0f, lineTop2 - 3.0f, lineRight2 + 4.0f, lineBottom2 + 3.0f, this.rectPaint);
        this.rectPaint.setColor(this.underlineColor);
        canvas.drawRect(0.0f, (float)(height - this.underlineHeight), (float)this.tabsContainer.getWidth(), (float)height, this.rectPaint);
        this.dividerPaint.setColor(this.dividerColor);
        for (int i = 0; i < this.tabCount - 1; ++i) {
            View tab = this.tabsContainer.getChildAt(i);
            canvas.drawLine((float)tab.getRight(), (float)this.dividerPadding, (float)tab.getRight(), (float)(height - this.dividerPadding), this.dividerPaint);
        }
    }

    public void setIndicatorColorResource(int resId) {
        this.indicatorColor = this.getResources().getColor(resId);
        this.invalidate();
    }

    public int getIndicatorColor() {
        return this.indicatorColor;
    }

    public void setIndicatorColor(int indicatorColor) {
        this.indicatorColor = indicatorColor;
        this.invalidate();
    }

    public int getIndicatorHeight() {
        return this.indicatorHeight;
    }

    public void setIndicatorHeight(int indicatorLineHeightPx) {
        this.indicatorHeight = indicatorLineHeightPx;
        this.invalidate();
    }

    public void setUnderlineColorResource(int resId) {
        this.underlineColor = this.getResources().getColor(resId);
        this.invalidate();
    }

    public int getUnderlineColor() {
        return this.underlineColor;
    }

    public void setUnderlineColor(int underlineColor) {
        this.underlineColor = underlineColor;
        this.invalidate();
    }

    public void setDividerColorResource(int resId) {
        this.dividerColor = this.getResources().getColor(resId);
        this.invalidate();
    }

    public int getDividerColor() {
        return this.dividerColor;
    }

    public void setDividerColor(int dividerColor) {
        this.dividerColor = dividerColor;
        this.invalidate();
    }

    public int getUnderlineHeight() {
        return this.underlineHeight;
    }

    public void setUnderlineHeight(int underlineHeightPx) {
        this.underlineHeight = underlineHeightPx;
        this.invalidate();
    }

    public int getDividerPadding() {
        return this.dividerPadding;
    }

    public void setDividerPadding(int dividerPaddingPx) {
        this.dividerPadding = dividerPaddingPx;
        this.invalidate();
    }

    public int getScrollOffset() {
        return this.scrollOffset;
    }

    public void setScrollOffset(int scrollOffsetPx) {
        this.scrollOffset = scrollOffsetPx;
        this.invalidate();
    }

    public boolean getShouldExpand() {
        return this.shouldExpand;
    }

    public void setShouldExpand(boolean shouldExpand) {
        this.shouldExpand = shouldExpand;
        this.requestLayout();
    }

    public boolean isTextAllCaps() {
        return this.textAllCaps;
    }

    public void setAllCaps(boolean textAllCaps) {
        this.textAllCaps = textAllCaps;
    }

    public int getTextSize() {
        return this.tabTextSize;
    }

    public void setTextSize(int textSizePx) {
        this.tabTextSize = textSizePx;
        this.updateTabStyles();
    }

    public void setTextColorResource(int resId) {
        this.tabTextColor = this.getResources().getColor(resId);
        this.updateTabStyles();
    }

    public int getTextColor() {
        return this.tabTextColor;
    }

    public void setTextColor(int textColor) {
        this.tabTextColor = textColor;
        this.updateTabStyles();
    }

    public void setTypeface(Typeface typeface, int style) {
        this.tabTypeface = typeface;
        this.tabTypefaceStyle = style;
        this.updateTabStyles();
    }

    public int getTabBackground() {
        return this.tabBackgroundResId;
    }

    public void setTabBackground(int resId) {
        this.tabBackgroundResId = resId;
    }

    public int getTabPaddingLeftRight() {
        return this.tabPadding;
    }

    public void setTabPaddingLeftRight(int paddingPx) {
        this.tabPadding = paddingPx;
        this.updateTabStyles();
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.currentPosition = savedState.currentPosition;
        this.requestLayout();
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.currentPosition = this.currentPosition;
        return savedState;
    }

    private class PageListener
    implements ViewPager.OnPageChangeListener {
        private PageListener() {
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            PagerSlidingTabStrip.this.currentPosition = position;
            PagerSlidingTabStrip.this.currentPositionOffset = positionOffset;
            PagerSlidingTabStrip.this.scrollToChild(position, (int)(positionOffset * (float)PagerSlidingTabStrip.this.tabsContainer.getChildAt(position).getWidth()));
            PagerSlidingTabStrip.this.invalidate();
            if (PagerSlidingTabStrip.this.delegatePageListener != null) {
                PagerSlidingTabStrip.this.delegatePageListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
            }
        }

        public void onPageScrollStateChanged(int state) {
            if (state == 0) {
                PagerSlidingTabStrip.this.scrollToChild(PagerSlidingTabStrip.this.pager.getCurrentItem(), 0);
            }
            if (PagerSlidingTabStrip.this.delegatePageListener != null) {
                PagerSlidingTabStrip.this.delegatePageListener.onPageScrollStateChanged(state);
            }
        }

        public void onPageSelected(int position) {
            if (PagerSlidingTabStrip.this.delegatePageListener != null) {
                PagerSlidingTabStrip.this.delegatePageListener.onPageSelected(position);
            }
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };
        int currentPosition;

        public SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.currentPosition = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.currentPosition);
        }
    }

    public static interface IconTabProvider {
        public String getPageIconResId(int var1);
    }
}

