/*
 * Decompiled with CFR 0.152.
 */
package com.luminous.pick;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.media.ThumbnailUtils;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.support.v4.view.PagerAdapter;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.luminous.pick.CustomGallery;
import com.luminous.pick.ImageListRecycleAdapter;
import com.luminous.pick.R;
import com.luminous.pick.utils.ViewPagerSwipeLess;
import com.nostra13.universalimageloader.cache.disc.DiskCache;
import com.nostra13.universalimageloader.cache.disc.impl.UnlimitedDiscCache;
import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.nostra13.universalimageloader.core.ImageLoader;
import com.nostra13.universalimageloader.core.ImageLoaderConfiguration;
import com.nostra13.universalimageloader.core.assist.ImageScaleType;
import com.nostra13.universalimageloader.core.listener.ImageLoadingListener;
import com.nostra13.universalimageloader.core.listener.SimpleImageLoadingListener;
import com.nostra13.universalimageloader.utils.StorageUtils;
import crop.Crop;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class VideoPickActivity
extends Activity {
    private static final int ACTION_REQUEST_VIDEO_FROM_CAMERA = 201;
    private static final int ACTION_REQUEST_VIDEO_FROM_GALLERY = 202;
    private static AlertDialog alertDialog;
    String action = "luminous.ACTION_PICK";
    private ImageLoader imageLoader;
    private ViewPagerSwipeLess mPager;
    private HashMap<String, CustomGallery> dataT;
    private CustomPagerAdapter adapter;
    private ImageListRecycleAdapter mImageListAdapter;
    Bitmap thumbnail = null;

    public static void showAlertDialog(Context mContext, String text) {
        alertDialog = new AlertDialog.Builder(mContext).setMessage((CharSequence)text).setCancelable(false).setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                alertDialog.dismiss();
            }
        }).create();
        alertDialog.show();
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_video_preview);
        this.initImageLoader();
        this.mPager = (ViewPagerSwipeLess)this.findViewById(R.id.pager);
        this.dataT = new HashMap();
        this.adapter = new CustomPagerAdapter(this.dataT);
        this.mPager.setAdapter(this.adapter);
        this.mImageListAdapter = new ImageListRecycleAdapter((Context)this, this.dataT);
        RecyclerView mRecycleView = (RecyclerView)this.findViewById(R.id.image_hlistview);
        mRecycleView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this, 0, false));
        mRecycleView.setAdapter((RecyclerView.Adapter)this.mImageListAdapter);
        this.mImageListAdapter.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                VideoPickActivity.this.mPager.setCurrentItem(position);
            }
        });
        this.findViewById(R.id.navigate_crop).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (VideoPickActivity.this.adapter != null && VideoPickActivity.this.adapter.getCount() > 0) {
                    String imagePath = ((VideoPickActivity)VideoPickActivity.this).mImageListAdapter.mItems.get((int)((VideoPickActivity)VideoPickActivity.this).mPager.getCurrentItem()).sdcardPath;
                    Crop.of(Uri.parse((String)("file://" + imagePath)), Uri.parse((String)("file://" + imagePath))).asSquare().start(VideoPickActivity.this);
                }
            }
        });
        this.findViewById(R.id.add_image_navigate).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VideoPickActivity.this.openVideoFromGallery();
            }
        });
        this.findViewById(R.id.btn_cancel).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent data2 = new Intent();
                VideoPickActivity.this.setResult(0, data2);
                VideoPickActivity.this.finish();
            }
        });
        ((TextView)this.findViewById(R.id.btn_done_text)).setText((CharSequence)"Send");
        this.findViewById(R.id.btn_done).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ArrayList mArrayList = new ArrayList(VideoPickActivity.this.dataT.values());
                if (mArrayList.size() > 0) {
                    String[] allPath = new String[mArrayList.size()];
                    for (int i = 0; i < allPath.length; ++i) {
                        allPath[i] = ((CustomGallery)mArrayList.get((int)i)).sdcardPath;
                    }
                    Intent data = new Intent().putExtra("all_path", allPath);
                    VideoPickActivity.this.setResult(-1, data);
                    VideoPickActivity.this.finish();
                } else {
                    VideoPickActivity.showAlertDialog((Context)VideoPickActivity.this, "Please select a video.");
                }
            }
        });
        this.findViewById(R.id.navigate_crop).setVisibility(8);
        if (this.getIntent().getAction() != null) {
            this.action = this.getIntent().getAction();
        }
        if (this.getIntent().getExtras().getBoolean("from")) {
            this.openVideoFromGallery();
        } else {
            this.openVideoFromCamera();
        }
    }

    public void openVideoFromCamera() {
        ContentValues values = new ContentValues();
        String fileName = System.currentTimeMillis() + ".mp4";
        values.put("title", fileName);
        values.put("mime_type", "video/mp4");
        try {
            Uri videoUriFromCamera = this.getContentResolver().insert(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, values);
            Intent intent = new Intent("android.media.action.VIDEO_CAPTURE");
            intent.putExtra("android.intent.extra.videoQuality", 1);
            this.startActivityForResult(intent, 201);
        }
        catch (Exception e) {
            e.printStackTrace();
            Toast.makeText((Context)this, (CharSequence)"SD-Card not available", (int)1).show();
        }
    }

    void openVideoFromGallery() {
        try {
            Intent intent = new Intent();
            intent.setType("video/*");
            intent.setAction("android.intent.action.GET_CONTENT");
            this.startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)"Select Video"), 202);
        }
        catch (Exception e) {
            VideoPickActivity.showAlertDialog((Context)this, "Device does not support video pick.");
        }
    }

    Bitmap getBitmapFromPath(final CustomGallery item) {
        try {
            Handler mHandler = new Handler();
            mHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        item.bitmap = VideoPickActivity.this.thumbnail = ThumbnailUtils.createVideoThumbnail((String)item.sdcardPath, (int)1);
                        VideoPickActivity.this.dataT.put(item.sdcardPath, item);
                        VideoPickActivity.this.mImageListAdapter.customNotify(VideoPickActivity.this.dataT);
                        VideoPickActivity.this.adapter.customNotify(VideoPickActivity.this.dataT);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            Log.w((String)"imagePath", (String)item.sdcardPath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.thumbnail;
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            if (requestCode == 201) {
                if (this.action.equals("luminous.ACTION_PICK")) {
                    this.dataT.clear();
                }
                String[] projection = new String[]{"_data"};
                Cursor cursor = this.managedQuery(data.getData(), projection, null, null, null);
                int column_index_data = cursor.getColumnIndexOrThrow("_data");
                cursor.moveToFirst();
                String videoUriFromCamera = cursor.getString(column_index_data);
                String[] allPath = new String[]{videoUriFromCamera};
                Intent data2 = new Intent().putExtra("all_path", allPath);
                this.setResult(-1, data2);
                this.finish();
            } else if (requestCode == 202) {
                Cursor cursor = this.getContentResolver().query(data.getData(), new String[]{"_data", "duration", "_size"}, null, null, null);
                cursor.moveToFirst();
                String mVideoPath = cursor.getString(cursor.getColumnIndexOrThrow("_data"));
                if (mVideoPath == null) {
                    mVideoPath = this.getPath(data.getData(), (Context)this);
                }
                String[] allPath = new String[]{mVideoPath};
                Intent data2 = new Intent().putExtra("all_path", allPath);
                this.setResult(-1, data2);
                this.finish();
            }
        } else if (this.dataT == null || this.dataT.size() <= 0) {
            Intent data2 = new Intent();
            this.setResult(0, data2);
            this.finish();
        }
    }

    @SuppressLint(value={"NewApi"})
    private String getPath(Uri uri, Context context) {
        Cursor cursor;
        if (uri == null) {
            return null;
        }
        String[] projection = new String[]{"_data"};
        if (Build.VERSION.SDK_INT > 19) {
            String wholeID = DocumentsContract.getDocumentId((Uri)uri);
            String id2 = wholeID.split(":")[1];
            String sel = "_id=?";
            cursor = context.getContentResolver().query(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, projection, sel, new String[]{id2}, null);
        } else {
            cursor = context.getContentResolver().query(uri, projection, null, null, null);
        }
        String path = null;
        try {
            int column_index = cursor.getColumnIndex("_data");
            cursor.moveToFirst();
            path = cursor.getString(column_index).toString();
            cursor.close();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        return path;
    }

    private void initImageLoader() {
        try {
            String CACHE_DIR = Environment.getExternalStorageDirectory().getAbsolutePath() + "/.temp_tmp";
            new File(CACHE_DIR).mkdirs();
            File cacheDir = StorageUtils.getOwnCacheDirectory((Context)this.getBaseContext(), (String)CACHE_DIR);
            DisplayImageOptions defaultOptions = new DisplayImageOptions.Builder().cacheOnDisk(true).imageScaleType(ImageScaleType.EXACTLY).bitmapConfig(Bitmap.Config.RGB_565).build();
            ImageLoaderConfiguration.Builder builder = new ImageLoaderConfiguration.Builder(this.getBaseContext()).defaultDisplayImageOptions(defaultOptions).diskCache((DiskCache)new UnlimitedDiscCache(cacheDir));
            ImageLoaderConfiguration config = builder.build();
            this.imageLoader = ImageLoader.getInstance();
            this.imageLoader.init(config);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class CustomPagerAdapter
    extends PagerAdapter {
        LayoutInflater mLayoutInflater;
        ArrayList<CustomGallery> dataT;

        public CustomPagerAdapter(HashMap<String, CustomGallery> dataT) {
            this.dataT = new ArrayList<CustomGallery>(dataT.values());
            this.mLayoutInflater = (LayoutInflater)VideoPickActivity.this.getSystemService("layout_inflater");
        }

        public void customNotify(HashMap<String, CustomGallery> dataHashmap) {
            this.dataT.clear();
            ArrayList<CustomGallery> dataT2 = new ArrayList<CustomGallery>(dataHashmap.values());
            this.dataT.addAll(dataT2);
            this.notifyDataSetChanged();
        }

        public int getCount() {
            return this.dataT.size();
        }

        public boolean isViewFromObject(View view, Object object) {
            return view == (LinearLayout)object;
        }

        public int getItemPosition(Object object) {
            return -2;
        }

        public Object instantiateItem(ViewGroup container, int position) {
            View itemView = this.mLayoutInflater.inflate(R.layout.image_pager_item, container, false);
            final ImageView imageView = (ImageView)itemView.findViewById(R.id.full_screen_image);
            if (this.dataT.get((int)position).bitmap != null) {
                imageView.setImageBitmap(this.dataT.get((int)position).bitmap);
            } else {
                VideoPickActivity.this.imageLoader.displayImage("file://" + this.dataT.get((int)position).sdcardPath, imageView, (ImageLoadingListener)new SimpleImageLoadingListener(){

                    public void onLoadingStarted(String imageUri, View view) {
                        imageView.setImageResource(R.drawable.placeholder_470x352);
                        super.onLoadingStarted(imageUri, view);
                    }
                });
                container.addView(itemView);
            }
            return itemView;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            container.removeView((View)((LinearLayout)object));
        }
    }
}

