/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.htime.jodatime;

import com.cronutils.htime.DateTimeFormatParser;
import com.cronutils.htime.DatetimeFormatterConstants;
import com.cronutils.htime.HDateTimeFormat;
import com.cronutils.htime.jodatime.JodaTimeDatetimeFormatterConstants;
import java.util.Locale;
import org.apache.commons.lang3.Validate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class JodaTimeHDateTimeFormat
implements HDateTimeFormat<DateTimeFormatter> {
    private Locale locale;
    private DatetimeFormatterConstants constants;

    public JodaTimeHDateTimeFormat(Locale locale) {
        Validate.notNull((Object)locale, (String)"Locale should not be null", (Object[])new Object[0]);
        this.locale = locale;
        this.constants = new JodaTimeDatetimeFormatterConstants();
    }

    @Override
    public DateTimeFormatter forPattern(String expression) {
        Validate.notBlank((CharSequence)expression, (String)"Expression must not be blank or null", (Object[])new Object[0]);
        DateTimeFormatParser parser = new DateTimeFormatParser(this.constants, this.locale);
        expression = expression.replaceAll("\\s+", " ");
        expression = expression.replace(" AM", "AM").replace(" am", "am").replace(" PM", "PM").replace(" pm", "pm");
        String[] parts = expression.split(" ");
        StringBuilder builder = new StringBuilder();
        for (String part : parts) {
            builder.append(String.format("%s ", parser.parsePattern(part)));
        }
        return DateTimeFormat.forPattern((String)builder.toString().trim());
    }
}

