/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.converter;

import com.cronutils.converter.CalendarToCronTransformer;
import com.cronutils.converter.CronToCalendarTransformer;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CronConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CronConverter.class);
    private static final String CRON_FIELDS_SEPARATOR = " ";
    private String[] cronParts;
    private Calendar fromCalendar;
    private String sourceCron;
    private ZoneId sourceZoneId;
    private ZoneId targetZoneId;
    CronToCalendarTransformer toCalendarConverter = new CronToCalendarTransformer();
    CalendarToCronTransformer toCronConverter = new CalendarToCronTransformer();

    public CronConverter using(String cronExpression) {
        this.sourceCron = cronExpression;
        this.cronParts = cronExpression.split(CRON_FIELDS_SEPARATOR);
        LOGGER.debug("Cron '{}' split into {}", (Object)cronExpression, (Object)this.cronParts);
        return this;
    }

    public CronConverter from(ZoneId zoneId) {
        this.sourceZoneId = zoneId;
        this.fromCalendar = this.getCalendar(zoneId);
        this.toCalendarConverter.apply(this.cronParts, this.fromCalendar);
        LOGGER.debug("Calendar object built using cron :{} and zoneID {} => {}", new Object[]{this.cronParts, zoneId, this.fromCalendar});
        return this;
    }

    public CronConverter to(ZoneId zoneId) {
        this.targetZoneId = zoneId;
        Calendar toCalendar = this.getCalendar(zoneId);
        toCalendar.setTimeInMillis(this.fromCalendar.getTimeInMillis());
        LOGGER.debug("Calendar object built from calendar {} and zoneID {} => {}", new Object[]{this.fromCalendar, zoneId, toCalendar});
        this.toCronConverter.apply(this.cronParts, toCalendar);
        LOGGER.debug("cron after applying calendar {} => {}", (Object)toCalendar, (Object)this.cronParts);
        return this;
    }

    public String convert() {
        String targetCron = StringUtils.join((Object[])this.cronParts, (String)CRON_FIELDS_SEPARATOR);
        LOGGER.info("Converted CRON -- {} :[{}] => {} :[{}]", new Object[]{this.sourceZoneId, this.sourceCron, this.targetZoneId, targetCron});
        return targetCron;
    }

    private Calendar getCalendar(ZoneId id) {
        return Calendar.getInstance(TimeZone.getTimeZone(id));
    }

    public void setToCalendarConverter(CronToCalendarTransformer toCalendarConverter) {
        this.toCalendarConverter = toCalendarConverter;
    }

    public void setToCronConverter(CalendarToCronTransformer toCronConverter) {
        this.toCronConverter = toCronConverter;
    }
}

