/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.time;

import com.cronutils.model.CompositeCron;
import com.cronutils.model.Cron;
import com.cronutils.model.SingleCron;
import com.cronutils.model.field.CronField;
import com.cronutils.model.field.CronFieldName;
import com.cronutils.model.time.CompositeExecutionTime;
import com.cronutils.model.time.ExecutionTimeBuilder;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public interface ExecutionTime {
    public static ExecutionTime forCron(Cron cron) {
        if (cron instanceof SingleCron) {
            Map<CronFieldName, CronField> fields = cron.retrieveFieldsAsMap();
            ExecutionTimeBuilder executionTimeBuilder = new ExecutionTimeBuilder(cron.getCronDefinition());
            block10: for (CronFieldName name : CronFieldName.values()) {
                if (fields.get((Object)name) == null) continue;
                switch (name) {
                    case SECOND: {
                        executionTimeBuilder.forSecondsMatching(fields.get((Object)name));
                        continue block10;
                    }
                    case MINUTE: {
                        executionTimeBuilder.forMinutesMatching(fields.get((Object)name));
                        continue block10;
                    }
                    case HOUR: {
                        executionTimeBuilder.forHoursMatching(fields.get((Object)name));
                        continue block10;
                    }
                    case DAY_OF_WEEK: {
                        executionTimeBuilder.forDaysOfWeekMatching(fields.get((Object)name));
                        continue block10;
                    }
                    case DAY_OF_MONTH: {
                        executionTimeBuilder.forDaysOfMonthMatching(fields.get((Object)name));
                        continue block10;
                    }
                    case MONTH: {
                        executionTimeBuilder.forMonthsMatching(fields.get((Object)name));
                        continue block10;
                    }
                    case YEAR: {
                        executionTimeBuilder.forYearsMatching(fields.get((Object)name));
                        continue block10;
                    }
                    case DAY_OF_YEAR: {
                        executionTimeBuilder.forDaysOfYearMatching(fields.get((Object)name));
                        continue block10;
                    }
                }
            }
            return executionTimeBuilder.build();
        }
        return new CompositeExecutionTime(((CompositeCron)cron).getCrons().parallelStream().map(ExecutionTime::forCron).collect(Collectors.toList()));
    }

    public Optional<ZonedDateTime> nextExecution(ZonedDateTime var1);

    public Optional<Duration> timeToNextExecution(ZonedDateTime var1);

    public Optional<ZonedDateTime> lastExecution(ZonedDateTime var1);

    public Optional<Duration> timeFromLastExecution(ZonedDateTime var1);

    public boolean isMatch(ZonedDateTime var1);
}

