/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.definition;

import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronConstraint;
import com.cronutils.model.definition.CronConstraintsFactory;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder$$Lambda$1;
import com.cronutils.model.definition.CronDefinitionBuilder$$Lambda$2;
import com.cronutils.model.field.CronFieldName;
import com.cronutils.model.field.definition.FieldDayOfWeekDefinitionBuilder;
import com.cronutils.model.field.definition.FieldDefinition;
import com.cronutils.model.field.definition.FieldDefinitionBuilder;
import com.cronutils.model.field.definition.FieldQuestionMarkDefinitionBuilder;
import com.cronutils.model.field.definition.FieldSpecialCharsDefinitionBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class CronDefinitionBuilder {
    private final Map<CronFieldName, FieldDefinition> fields = new HashMap<CronFieldName, FieldDefinition>();
    private final Set<CronConstraint> cronConstraints = new HashSet<CronConstraint>();
    private boolean enforceStrictRanges;
    private boolean matchDayOfWeekAndDayOfMonth;

    private CronDefinitionBuilder() {
    }

    public static CronDefinitionBuilder defineCron() {
        return new CronDefinitionBuilder();
    }

    public FieldDefinitionBuilder withSeconds() {
        return new FieldDefinitionBuilder(this, CronFieldName.SECOND);
    }

    public FieldDefinitionBuilder withMinutes() {
        return new FieldDefinitionBuilder(this, CronFieldName.MINUTE);
    }

    public FieldDefinitionBuilder withHours() {
        return new FieldDefinitionBuilder(this, CronFieldName.HOUR);
    }

    public FieldSpecialCharsDefinitionBuilder withDayOfMonth() {
        return new FieldSpecialCharsDefinitionBuilder(this, CronFieldName.DAY_OF_MONTH);
    }

    public FieldDefinitionBuilder withMonth() {
        return new FieldDefinitionBuilder(this, CronFieldName.MONTH);
    }

    public FieldDayOfWeekDefinitionBuilder withDayOfWeek() {
        return new FieldDayOfWeekDefinitionBuilder(this, CronFieldName.DAY_OF_WEEK);
    }

    public FieldDefinitionBuilder withYear() {
        return new FieldDefinitionBuilder(this, CronFieldName.YEAR);
    }

    public FieldQuestionMarkDefinitionBuilder withDayOfYear() {
        return new FieldQuestionMarkDefinitionBuilder(this, CronFieldName.DAY_OF_YEAR);
    }

    public CronDefinitionBuilder enforceStrictRanges() {
        this.enforceStrictRanges = true;
        return this;
    }

    public CronDefinitionBuilder matchDayOfWeekAndDayOfMonth() {
        this.matchDayOfWeekAndDayOfMonth = true;
        return this;
    }

    public CronDefinitionBuilder withCronValidation(CronConstraint validation) {
        this.cronConstraints.add(validation);
        return this;
    }

    public void register(FieldDefinition definition) {
        if (!definition.isOptional() && this.fields.values().stream().anyMatch(CronDefinitionBuilder$$Lambda$1.lambdaFactory$())) {
            throw new IllegalArgumentException("Can't register mandatory definition after a optional definition.");
        }
        this.fields.put(definition.getFieldName(), definition);
    }

    public CronDefinition instance() {
        HashSet<CronConstraint> validations = new HashSet<CronConstraint>();
        validations.addAll(this.cronConstraints);
        return new CronDefinition(this.fields.values().stream().sorted(CronDefinitionBuilder$$Lambda$2.lambdaFactory$()).collect(Collectors.toList()), validations, this.enforceStrictRanges, this.matchDayOfWeekAndDayOfMonth);
    }

    private static CronDefinition cron4j() {
        return CronDefinitionBuilder.defineCron().withMinutes().and().withHours().and().withDayOfMonth().supportsL().and().withMonth().and().withDayOfWeek().withValidRange(0, 6).withMondayDoWValue(1).and().enforceStrictRanges().matchDayOfWeekAndDayOfMonth().instance();
    }

    private static CronDefinition quartz() {
        return CronDefinitionBuilder.defineCron().withSeconds().and().withMinutes().and().withHours().and().withDayOfMonth().supportsL().supportsW().supportsLW().supportsQuestionMark().and().withMonth().and().withDayOfWeek().withValidRange(1, 7).withMondayDoWValue(2).supportsHash().supportsL().supportsQuestionMark().and().withYear().withValidRange(1970, 2099).optional().and().withCronValidation(CronConstraintsFactory.ensureEitherDayOfWeekOrDayOfMonth()).instance();
    }

    private static CronDefinition unixCrontab() {
        return CronDefinitionBuilder.defineCron().withMinutes().and().withHours().and().withDayOfMonth().and().withMonth().and().withDayOfWeek().withValidRange(0, 7).withMondayDoWValue(1).withIntMapping(7, 0).and().enforceStrictRanges().instance();
    }

    public static CronDefinition instanceDefinitionFor(CronType cronType) {
        switch (cronType) {
            case CRON4J: {
                return CronDefinitionBuilder.cron4j();
            }
            case QUARTZ: {
                return CronDefinitionBuilder.quartz();
            }
            case UNIX: {
                return CronDefinitionBuilder.unixCrontab();
            }
        }
        throw new RuntimeException(String.format("No cron definition found for %s", new Object[]{cronType}));
    }

    static /* synthetic */ int lambda$instance$1(FieldDefinition o1, FieldDefinition o2) {
        return o1.getFieldName().getOrder() - o2.getFieldName().getOrder();
    }

    static /* synthetic */ boolean lambda$register$0(FieldDefinition def) {
        return def.isOptional();
    }
}

