/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.field.expression.visitor;

import com.cronutils.model.field.expression.Always;
import com.cronutils.model.field.expression.And;
import com.cronutils.model.field.expression.Between;
import com.cronutils.model.field.expression.Every;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.field.expression.On;
import com.cronutils.model.field.expression.QuestionMark;
import com.cronutils.model.field.expression.visitor.FieldExpressionVisitor;
import com.cronutils.model.field.value.FieldValue;
import com.cronutils.model.field.value.IntegerFieldValue;
import java.util.function.Function;

public class ValueMappingFieldExpressionVisitor
implements FieldExpressionVisitor {
    private Function<FieldValue, FieldValue> transform;

    public ValueMappingFieldExpressionVisitor(Function<FieldValue, FieldValue> transform) {
        this.transform = transform;
    }

    @Override
    public FieldExpression visit(Always always) {
        return always;
    }

    @Override
    public FieldExpression visit(And and) {
        And clone = new And();
        for (FieldExpression expression : and.getExpressions()) {
            clone.and(this.visit(expression));
        }
        return clone;
    }

    @Override
    public FieldExpression visit(Between between) {
        FieldValue from = this.transform.apply(between.getFrom());
        FieldValue to = this.transform.apply(between.getTo());
        return new Between(from, to);
    }

    @Override
    public FieldExpression visit(Every every) {
        return new Every((IntegerFieldValue)this.transform.apply(every.getPeriod()));
    }

    @Override
    public FieldExpression visit(On on) {
        return new On((IntegerFieldValue)this.transform.apply(on.getTime()), on.getSpecialChar(), on.getNth());
    }

    @Override
    public FieldExpression visit(QuestionMark questionMark) {
        return new QuestionMark();
    }

    @Override
    public FieldExpression visit(FieldExpression expression) {
        if (expression instanceof Always) {
            return this.visit((Always)expression);
        }
        if (expression instanceof And) {
            return this.visit((And)expression);
        }
        if (expression instanceof Between) {
            return this.visit((Between)expression);
        }
        if (expression instanceof Every) {
            return this.visit((Every)expression);
        }
        if (expression instanceof On) {
            return this.visit((On)expression);
        }
        if (expression instanceof QuestionMark) {
            return this.visit((QuestionMark)expression);
        }
        return expression;
    }
}

