/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.field.expression;

import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.field.value.IntegerFieldValue;
import com.cronutils.model.field.value.SpecialChar;
import com.cronutils.model.field.value.SpecialCharFieldValue;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.Validate;

public class On
extends FieldExpression {
    private static final int DEFAULT_NTH_VALUE = -1;
    private IntegerFieldValue time;
    private IntegerFieldValue nth;
    private SpecialCharFieldValue specialChar;

    private On(On on) {
        this(on.time, on.specialChar, on.nth);
    }

    public On(SpecialCharFieldValue specialChar) {
        this(new IntegerFieldValue(-1), specialChar);
    }

    public On(IntegerFieldValue time) {
        this(time, new SpecialCharFieldValue(SpecialChar.NONE));
    }

    public On(IntegerFieldValue time, SpecialCharFieldValue specialChar) {
        this(time, specialChar, new IntegerFieldValue(-1));
        Preconditions.checkArgument((!specialChar.getValue().equals((Object)SpecialChar.HASH) ? 1 : 0) != 0, (Object)"value missing for a#b cron expression");
    }

    public On(IntegerFieldValue time, SpecialCharFieldValue specialChar, IntegerFieldValue nth) {
        Validate.notNull((Object)time, (String)"time must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)specialChar, (String)"special char must not null", (Object[])new Object[0]);
        Validate.notNull((Object)nth, (String)"nth value must not be null", (Object[])new Object[0]);
        this.time = time;
        this.specialChar = specialChar;
        this.nth = nth;
    }

    public IntegerFieldValue getTime() {
        return this.time;
    }

    public IntegerFieldValue getNth() {
        return this.nth;
    }

    public SpecialCharFieldValue getSpecialChar() {
        return this.specialChar;
    }

    @Override
    public String asString() {
        switch (this.specialChar.getValue()) {
            case NONE: {
                return this.getTime().toString();
            }
            case HASH: {
                return String.format("%s#%s", this.getTime(), this.getNth());
            }
            case W: {
                return this.isDefault(this.getTime()) ? "W" : String.format("%sW", this.getTime());
            }
            case L: {
                return this.isDefault(this.getTime()) ? "L" : String.format("%sL", this.getTime());
            }
        }
        return this.specialChar.toString();
    }

    private boolean isDefault(IntegerFieldValue fieldValue) {
        return fieldValue.getValue() == -1;
    }
}

