/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.mapper;

import com.google.common.annotations.VisibleForTesting;
import java.util.function.Function;
import org.apache.commons.lang3.Validate;

@VisibleForTesting
public class WeekDay {
    private int mondayDoWValue;
    private boolean firstDayZero;

    public WeekDay(int mondayDoWValue, boolean firstDayZero) {
        Validate.isTrue((mondayDoWValue >= 0 ? 1 : 0) != 0, (String)"Monday Day of Week value must be greater or equal to zero", (Object[])new Object[0]);
        this.mondayDoWValue = mondayDoWValue;
        this.firstDayZero = firstDayZero;
    }

    public int getMondayDoWValue() {
        return this.mondayDoWValue;
    }

    public boolean isFirstDayZero() {
        return this.firstDayZero;
    }

    public int mapTo(int dayOfWeek, WeekDay targetWeekDayDefinition) {
        if (this.firstDayZero && targetWeekDayDefinition.isFirstDayZero()) {
            return this.bothSameStartOfRange(0, 6, this, targetWeekDayDefinition).apply(dayOfWeek);
        }
        if (!this.firstDayZero && !targetWeekDayDefinition.isFirstDayZero()) {
            return this.bothSameStartOfRange(1, 7, this, targetWeekDayDefinition).apply(dayOfWeek);
        }
        if (targetWeekDayDefinition.isFirstDayZero()) {
            return this.mapTo(dayOfWeek, new WeekDay(targetWeekDayDefinition.getMondayDoWValue() + 1, false)) - 1;
        }
        return this.mapTo(dayOfWeek, new WeekDay(targetWeekDayDefinition.getMondayDoWValue() - 1, true)) + 1;
    }

    private Function<Integer, Integer> bothSameStartOfRange(int startRange, int endRange, WeekDay source, WeekDay target) {
        return integer -> {
            int diff = target.getMondayDoWValue() - source.getMondayDoWValue();
            int result = integer;
            if (diff == 0) {
                return integer;
            }
            if (diff < 0) {
                result = integer + diff;
                int distanceToStartRange = startRange - result;
                if (result < startRange) {
                    result = endRange + 1 - distanceToStartRange;
                }
            }
            if (diff > 0 && (result = integer + diff) > endRange) {
                result -= endRange;
            }
            return result;
        };
    }
}

