/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.time;

import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.field.CronField;
import com.cronutils.model.field.CronFieldName;
import com.cronutils.model.field.constraint.FieldConstraints;
import com.cronutils.model.field.constraint.FieldConstraintsBuilder;
import com.cronutils.model.field.expression.Always;
import com.cronutils.model.field.expression.On;
import com.cronutils.model.field.value.IntegerFieldValue;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.model.time.TimeNode;
import com.cronutils.model.time.generator.FieldValueGenerator;
import com.cronutils.model.time.generator.FieldValueGeneratorFactory;
import org.apache.commons.lang3.Validate;

class ExecutionTimeBuilder {
    private CronDefinition cronDefinition;
    private FieldValueGenerator yearsValueGenerator;
    private CronField daysOfWeekCronField;
    private CronField daysOfMonthCronField;
    private TimeNode months;
    private TimeNode hours;
    private TimeNode minutes;
    private TimeNode seconds;

    ExecutionTimeBuilder(CronDefinition cronDefinition) {
        this.cronDefinition = cronDefinition;
    }

    ExecutionTimeBuilder forSecondsMatching(CronField cronField) {
        this.validate(CronFieldName.SECOND, cronField);
        this.seconds = new TimeNode(FieldValueGeneratorFactory.forCronField(cronField).generateCandidates(0, 59));
        return this;
    }

    ExecutionTimeBuilder forMinutesMatching(CronField cronField) {
        this.validate(CronFieldName.MINUTE, cronField);
        this.minutes = new TimeNode(FieldValueGeneratorFactory.forCronField(cronField).generateCandidates(0, 59));
        return this;
    }

    ExecutionTimeBuilder forHoursMatching(CronField cronField) {
        this.validate(CronFieldName.HOUR, cronField);
        this.hours = new TimeNode(FieldValueGeneratorFactory.forCronField(cronField).generateCandidates(0, 23));
        return this;
    }

    ExecutionTimeBuilder forMonthsMatching(CronField cronField) {
        this.validate(CronFieldName.MONTH, cronField);
        this.months = new TimeNode(FieldValueGeneratorFactory.forCronField(cronField).generateCandidates(1, 12));
        return this;
    }

    ExecutionTimeBuilder forYearsMatching(CronField cronField) {
        this.validate(CronFieldName.YEAR, cronField);
        this.yearsValueGenerator = FieldValueGeneratorFactory.forCronField(cronField);
        return this;
    }

    ExecutionTimeBuilder forDaysOfWeekMatching(CronField cronField) {
        this.validate(CronFieldName.DAY_OF_WEEK, cronField);
        this.daysOfWeekCronField = cronField;
        return this;
    }

    ExecutionTimeBuilder forDaysOfMonthMatching(CronField cronField) {
        this.validate(CronFieldName.DAY_OF_MONTH, cronField);
        this.daysOfMonthCronField = cronField;
        return this;
    }

    ExecutionTime build() {
        FieldConstraints constraints;
        boolean lowestAssigned = false;
        if (this.seconds == null) {
            this.seconds = this.timeNodeLowest(CronFieldName.SECOND, 0, 59);
        } else {
            lowestAssigned = true;
        }
        if (this.minutes == null) {
            this.minutes = lowestAssigned ? this.timeNodeAlways(CronFieldName.MINUTE, 0, 59) : this.timeNodeLowest(CronFieldName.MINUTE, 0, 59);
        } else {
            lowestAssigned = true;
        }
        if (this.hours == null) {
            this.hours = lowestAssigned ? this.timeNodeAlways(CronFieldName.HOUR, 0, 23) : this.timeNodeLowest(CronFieldName.HOUR, 0, 23);
        } else {
            lowestAssigned = true;
        }
        if (this.daysOfMonthCronField == null) {
            constraints = this.getConstraint(CronFieldName.DAY_OF_MONTH);
            this.daysOfMonthCronField = lowestAssigned ? new CronField(CronFieldName.DAY_OF_MONTH, new Always(), constraints) : new CronField(CronFieldName.DAY_OF_MONTH, new On(new IntegerFieldValue(0)), constraints);
        } else {
            lowestAssigned = true;
        }
        if (this.daysOfWeekCronField == null) {
            constraints = this.getConstraint(CronFieldName.DAY_OF_WEEK);
            this.daysOfWeekCronField = lowestAssigned ? new CronField(CronFieldName.DAY_OF_WEEK, new Always(), constraints) : new CronField(CronFieldName.DAY_OF_WEEK, new On(new IntegerFieldValue(0)), constraints);
        } else {
            lowestAssigned = true;
        }
        if (this.months == null) {
            TimeNode timeNode = this.months = lowestAssigned ? this.timeNodeAlways(CronFieldName.MONTH, 0, 31) : this.timeNodeLowest(CronFieldName.MONTH, 0, 31);
        }
        if (this.yearsValueGenerator == null) {
            this.yearsValueGenerator = FieldValueGeneratorFactory.forCronField(new CronField(CronFieldName.YEAR, new Always(), this.getConstraint(CronFieldName.YEAR)));
        }
        return new ExecutionTime(this.cronDefinition, this.yearsValueGenerator, this.daysOfWeekCronField, this.daysOfMonthCronField, this.months, this.hours, this.minutes, this.seconds);
    }

    private TimeNode timeNodeLowest(CronFieldName name, int lower, int higher) {
        FieldConstraints constraints = this.getConstraint(name);
        return new TimeNode(FieldValueGeneratorFactory.forCronField(new CronField(name, new On(new IntegerFieldValue(lower)), constraints)).generateCandidates(lower, higher));
    }

    private TimeNode timeNodeAlways(CronFieldName name, int lower, int higher) {
        return new TimeNode(FieldValueGeneratorFactory.forCronField(new CronField(name, new Always(), this.getConstraint(name))).generateCandidates(lower, higher));
    }

    private void validate(CronFieldName name, CronField cronField) {
        Validate.notNull((Object)((Object)name), (String)"Reference CronFieldName cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)cronField.getField()), (String)"CronField's CronFieldName cannot be null", (Object[])new Object[0]);
        if (!name.equals((Object)cronField.getField())) {
            throw new IllegalArgumentException(String.format("Invalid argument! Expected CronField instance for field %s but found %s", new Object[]{cronField.getField(), name}));
        }
    }

    private FieldConstraints getConstraint(CronFieldName name) {
        return this.cronDefinition.getFieldDefinition(name) != null ? this.cronDefinition.getFieldDefinition(name).getConstraints() : FieldConstraintsBuilder.instance().forField(name).createConstraintsInstance();
    }
}

