/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.definition;

import com.cronutils.model.definition.CronConstraint;
import com.cronutils.model.field.CronFieldName;
import com.cronutils.model.field.definition.FieldDefinition;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;

public class CronDefinition {
    private Map<CronFieldName, FieldDefinition> fieldDefinitions;
    private Set<CronConstraint> cronConstraints;
    private boolean lastFieldOptional;
    private boolean strictRanges;

    public CronDefinition(List<FieldDefinition> fieldDefinitions, Set<CronConstraint> cronConstraints, boolean lastFieldOptional, boolean strictRanges) {
        Validate.notNull(fieldDefinitions, (String)"Field definitions must not be null", (Object[])new Object[0]);
        Validate.notNull(cronConstraints, (String)"Cron validations must not be null", (Object[])new Object[0]);
        Validate.notEmpty(fieldDefinitions, (String)"Field definitions must not be empty", (Object[])new Object[0]);
        if (lastFieldOptional) {
            Validate.isTrue((fieldDefinitions.size() > 1 ? 1 : 0) != 0, (String)"If last field is optional, field definition must hold at least two fields", (Object[])new Object[0]);
        }
        this.fieldDefinitions = Maps.newHashMap();
        for (FieldDefinition field : fieldDefinitions) {
            this.fieldDefinitions.put(field.getFieldName(), field);
        }
        this.cronConstraints = Collections.unmodifiableSet(cronConstraints);
        this.lastFieldOptional = lastFieldOptional;
        this.strictRanges = strictRanges;
    }

    public boolean isLastFieldOptional() {
        return this.lastFieldOptional;
    }

    public boolean isStrictRanges() {
        return this.strictRanges;
    }

    public Set<FieldDefinition> getFieldDefinitions() {
        return new HashSet<FieldDefinition>(this.fieldDefinitions.values());
    }

    public FieldDefinition getFieldDefinition(CronFieldName cronFieldName) {
        return this.fieldDefinitions.get((Object)cronFieldName);
    }

    public Set<CronConstraint> getCronConstraints() {
        return this.cronConstraints;
    }
}

