/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.time.generator;

import com.cronutils.model.field.CronField;
import com.cronutils.model.field.CronFieldName;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.field.expression.On;
import com.cronutils.model.time.generator.FieldValueGenerator;
import com.cronutils.model.time.generator.NoSuchValueException;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.joda.time.DateTime;

class OnDayOfMonthValueGenerator
extends FieldValueGenerator {
    private int year;
    private int month;

    public OnDayOfMonthValueGenerator(CronField cronField, int year, int month) {
        super(cronField.getExpression());
        Validate.isTrue((boolean)CronFieldName.DAY_OF_MONTH.equals((Object)cronField.getField()), (String)"CronField does not belong to day of month", (Object[])new Object[0]);
        this.year = year;
        this.month = month;
    }

    @Override
    public int generateNextValue(int reference) throws NoSuchValueException {
        On on = (On)this.expression;
        int value = this.generateValue(on, this.year, this.month);
        if (value <= reference) {
            throw new NoSuchValueException();
        }
        return value;
    }

    @Override
    public int generatePreviousValue(int reference) throws NoSuchValueException {
        On on = (On)this.expression;
        int value = this.generateValue(on, this.year, this.month);
        if (value >= reference) {
            throw new NoSuchValueException();
        }
        return value;
    }

    @Override
    protected List<Integer> generateCandidatesNotIncludingIntervalExtremes(int start, int end) {
        ArrayList values = Lists.newArrayList();
        try {
            int reference = this.generateNextValue(start);
            while (reference < end) {
                values.add(reference);
                reference = this.generateNextValue(reference);
            }
        }
        catch (NoSuchValueException e) {
            // empty catch block
        }
        return values;
    }

    @Override
    public boolean isMatch(int value) {
        On on = (On)this.expression;
        try {
            return value == this.generateValue(on, this.year, this.month);
        }
        catch (NoSuchValueException noSuchValueException) {
            return false;
        }
    }

    @Override
    protected boolean matchesFieldExpressionClass(FieldExpression fieldExpression) {
        return fieldExpression instanceof On;
    }

    private int generateValue(On on, int year, int month) throws NoSuchValueException {
        int time = on.getTime().getValue();
        switch (on.getSpecialChar().getValue()) {
            case L: {
                return new DateTime(year, month, 1, 1, 1).dayOfMonth().getMaximumValue();
            }
            case W: {
                DateTime doM = new DateTime(year, month, time, 1, 1);
                if (doM.getDayOfWeek() == 6) {
                    if (time == 1) {
                        return 3;
                    }
                    return time - 1;
                }
                if (doM.getDayOfWeek() == 7 && time + 1 <= doM.dayOfMonth().getMaximumValue()) {
                    return time + 1;
                }
                return time;
            }
            case LW: {
                DateTime lastDayOfMonth = new DateTime(year, month, new DateTime(year, month, 1, 1, 1).dayOfMonth().getMaximumValue(), 1, 1);
                int dow = lastDayOfMonth.getDayOfWeek();
                int diff = dow - 5;
                if (diff > 0) {
                    return lastDayOfMonth.minusDays(diff).dayOfMonth().get();
                }
                return lastDayOfMonth.dayOfMonth().get();
            }
        }
        throw new NoSuchValueException();
    }
}

