/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.definition;

import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.field.CronFieldName;
import com.cronutils.model.field.definition.FieldDayOfWeekDefinitionBuilder;
import com.cronutils.model.field.definition.FieldDefinition;
import com.cronutils.model.field.definition.FieldDefinitionBuilder;
import com.cronutils.model.field.definition.FieldSpecialCharsDefinitionBuilder;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;

public class CronDefinitionBuilder {
    private Map<CronFieldName, FieldDefinition> fields = Maps.newHashMap();
    private boolean lastFieldOptional = false;

    private CronDefinitionBuilder() {
    }

    public static CronDefinitionBuilder defineCron() {
        return new CronDefinitionBuilder();
    }

    public FieldDefinitionBuilder withSeconds() {
        return new FieldDefinitionBuilder(this, CronFieldName.SECOND);
    }

    public FieldDefinitionBuilder withMinutes() {
        return new FieldDefinitionBuilder(this, CronFieldName.MINUTE);
    }

    public FieldDefinitionBuilder withHours() {
        return new FieldDefinitionBuilder(this, CronFieldName.HOUR);
    }

    public FieldSpecialCharsDefinitionBuilder withDayOfMonth() {
        return new FieldSpecialCharsDefinitionBuilder(this, CronFieldName.DAY_OF_MONTH);
    }

    public FieldDefinitionBuilder withMonth() {
        return new FieldDefinitionBuilder(this, CronFieldName.MONTH);
    }

    public FieldDayOfWeekDefinitionBuilder withDayOfWeek() {
        return new FieldDayOfWeekDefinitionBuilder(this, CronFieldName.DAY_OF_WEEK);
    }

    public FieldDefinitionBuilder withYear() {
        return new FieldDefinitionBuilder(this, CronFieldName.YEAR);
    }

    public CronDefinitionBuilder lastFieldOptional() {
        this.lastFieldOptional = true;
        return this;
    }

    public void register(FieldDefinition definition) {
        this.fields.put(definition.getFieldName(), definition);
    }

    public CronDefinition instance() {
        return new CronDefinition(new ArrayList<FieldDefinition>(this.fields.values()), this.lastFieldOptional);
    }

    private static CronDefinition cron4j() {
        return CronDefinitionBuilder.defineCron().withMinutes().and().withHours().and().withDayOfMonth().and().withMonth().and().withDayOfWeek().withValidRange(0, 6).withMondayDoWValue(1).and().instance();
    }

    private static CronDefinition quartz() {
        return CronDefinitionBuilder.defineCron().withSeconds().and().withMinutes().and().withHours().and().withDayOfMonth().supportsHash().supportsL().supportsW().supportsLW().supportsQuestionMark().and().withMonth().and().withDayOfWeek().withValidRange(1, 7).withMondayDoWValue(2).supportsHash().supportsL().supportsW().supportsQuestionMark().and().withYear().withValidRange(1970, 2099).and().lastFieldOptional().instance();
    }

    private static CronDefinition unixCrontab() {
        return CronDefinitionBuilder.defineCron().withMinutes().and().withHours().and().withDayOfMonth().and().withMonth().and().withDayOfWeek().withValidRange(0, 7).withMondayDoWValue(1).withIntMapping(7, 0).and().instance();
    }

    public static CronDefinition instanceDefinitionFor(CronType cronType) {
        switch (cronType) {
            case CRON4J: {
                return CronDefinitionBuilder.cron4j();
            }
            case QUARTZ: {
                return CronDefinitionBuilder.quartz();
            }
            case UNIX: {
                return CronDefinitionBuilder.unixCrontab();
            }
        }
        throw new RuntimeException(String.format("No cron definition found for %s", new Object[]{cronType}));
    }
}

