/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.time;

import com.cronutils.model.time.NearestValue;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TimeNode {
    private static final Logger log = LoggerFactory.getLogger(TimeNode.class);
    protected List<Integer> values;

    public TimeNode(List<Integer> values) {
        this.values = (List)Validate.notEmpty(values, (String)"Values must not be empty", (Object[])new Object[0]);
        Collections.sort(this.values);
    }

    public NearestValue getNextValue(int reference, int shifts) {
        return this.getNearestForwardValue(reference, shifts);
    }

    public List<Integer> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public NearestValue getPreviousValue(int reference, int shifts) {
        return this.getNearestBackwardValue(reference, shifts);
    }

    @VisibleForTesting
    NearestValue getNearestForwardValue(int reference, int shiftsToApply) {
        ArrayList<Integer> values = new ArrayList<Integer>(this.values);
        int index = 0;
        boolean foundGreater = false;
        AtomicInteger shift = new AtomicInteger(0);
        if (!values.contains(reference)) {
            for (Integer value : values) {
                if (value <= reference) continue;
                index = values.indexOf(value);
                --shiftsToApply;
                foundGreater = true;
                break;
            }
            if (!foundGreater) {
                shift.incrementAndGet();
            }
        } else {
            index = values.indexOf(reference);
        }
        int value = (Integer)values.get(index);
        for (int j = 0; j < shiftsToApply; ++j) {
            value = this.getValueFromList(values, index + 1, shift);
            index = values.indexOf(value);
        }
        return new NearestValue(value, shift.get());
    }

    @VisibleForTesting
    NearestValue getNearestBackwardValue(int reference, int shiftsToApply) {
        ArrayList<Integer> values = new ArrayList<Integer>(this.values);
        Collections.reverse(values);
        int index = 0;
        boolean foundSmaller = false;
        if (!values.contains(reference)) {
            for (Integer value : values) {
                if (value >= reference) continue;
                index = values.indexOf(value);
                --shiftsToApply;
                foundSmaller = true;
                break;
            }
            if (!foundSmaller) {
                ++shiftsToApply;
            }
        } else {
            index = values.indexOf(reference);
        }
        AtomicInteger shift = new AtomicInteger(0);
        int value = (Integer)values.get(index);
        for (int j = 0; j < shiftsToApply; ++j) {
            value = this.getValueFromList(values, index + 1, shift);
            index = values.indexOf(value);
        }
        return new NearestValue(value, shift.get());
    }

    @VisibleForTesting
    int getValueFromList(List<Integer> values, int index, AtomicInteger shift) {
        Validate.notEmpty(values, (String)"List must not be empty", (Object[])new Object[0]);
        if (index < 0) {
            shift.incrementAndGet();
            return this.getValueFromList(values, index += values.size(), shift);
        }
        if (index >= values.size()) {
            shift.incrementAndGet();
            return this.getValueFromList(values, index -= values.size(), shift);
        }
        return values.get(index);
    }
}

