/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.time.generator;

import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.field.expression.On;
import com.cronutils.model.time.generator.FieldValueGenerator;
import com.cronutils.model.time.generator.NoSuchValueException;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

class OnFieldValueGenerator
extends FieldValueGenerator {
    public OnFieldValueGenerator(FieldExpression expression) {
        super(expression);
    }

    @Override
    public int generateNextValue(int reference) throws NoSuchValueException {
        int time = ((On)this.expression).getTime().getValue();
        if (time <= reference) {
            throw new NoSuchValueException();
        }
        return time;
    }

    @Override
    public int generatePreviousValue(int reference) throws NoSuchValueException {
        int time = ((On)this.expression).getTime().getValue();
        if (time >= reference) {
            throw new NoSuchValueException();
        }
        return time;
    }

    @Override
    protected List<Integer> generateCandidatesNotIncludingIntervalExtremes(int start, int end) {
        ArrayList values = Lists.newArrayList();
        int time = ((On)this.expression).getTime().getValue();
        if (time > start && time < end) {
            values.add(time);
        }
        return values;
    }

    @Override
    public boolean isMatch(int value) {
        return ((On)this.expression).getTime().getValue() == value;
    }

    @Override
    protected boolean matchesFieldExpressionClass(FieldExpression fieldExpression) {
        return fieldExpression instanceof On;
    }
}

