/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.time.generator;

import com.cronutils.mapper.ConstantsMapper;
import com.cronutils.mapper.WeekDay;
import com.cronutils.model.field.CronField;
import com.cronutils.model.field.CronFieldName;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.field.expression.On;
import com.cronutils.model.time.generator.FieldValueGenerator;
import com.cronutils.model.time.generator.NoSuchValueException;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.joda.time.DateTime;

class OnDayOfWeekValueGenerator
extends FieldValueGenerator {
    private int year;
    private int month;
    private WeekDay mondayDoWValue;

    public OnDayOfWeekValueGenerator(CronField cronField, int year, int month, WeekDay mondayDoWValue) {
        super(cronField.getExpression());
        Validate.isTrue((boolean)CronFieldName.DAY_OF_WEEK.equals((Object)cronField.getField()), (String)"CronField does not belong to day of week", (Object[])new Object[0]);
        this.year = year;
        this.month = month;
        this.mondayDoWValue = mondayDoWValue;
    }

    @Override
    public int generateNextValue(int reference) throws NoSuchValueException {
        On on = (On)this.expression;
        int value = this.generateValue(on, this.year, this.month, reference);
        if (value <= reference) {
            throw new NoSuchValueException();
        }
        return value;
    }

    @Override
    public int generatePreviousValue(int reference) throws NoSuchValueException {
        On on = (On)this.expression;
        int value = this.generateValue(on, this.year, this.month, reference);
        if (value >= reference) {
            throw new NoSuchValueException();
        }
        return value;
    }

    @Override
    protected List<Integer> generateCandidatesNotIncludingIntervalExtremes(int start, int end) {
        ArrayList values = Lists.newArrayList();
        try {
            int reference = this.generateNextValue(start);
            while (reference < end) {
                values.add(reference);
                reference = this.generateNextValue(reference);
            }
        }
        catch (NoSuchValueException e) {
            // empty catch block
        }
        return values;
    }

    @Override
    public boolean isMatch(int value) {
        On on = (On)this.expression;
        try {
            return value == this.generateValue(on, this.year, this.month, value);
        }
        catch (NoSuchValueException noSuchValueException) {
            return false;
        }
    }

    @Override
    protected boolean matchesFieldExpressionClass(FieldExpression fieldExpression) {
        return fieldExpression instanceof On;
    }

    private int generateValue(On on, int year, int month, int reference) throws NoSuchValueException {
        switch (on.getSpecialChar().getValue()) {
            case HASH: {
                return this.generateHashValues(on, year, month);
            }
            case L: {
                return this.generateLValues(on, year, month);
            }
            case NONE: {
                return this.generateNoneValues(on, year, month, reference);
            }
        }
        throw new NoSuchValueException();
    }

    private int generateHashValues(On on, int year, int month) {
        int dowForFirstDoM = new DateTime(year, month, 1, 1, 1).getDayOfWeek();
        int requiredDoW = ConstantsMapper.weekDayMapping(this.mondayDoWValue, ConstantsMapper.JODATIME_WEEK_DAY, on.getTime().getValue());
        int requiredNth = on.getNth().getValue();
        int baseDay = 1;
        int diff = dowForFirstDoM - requiredDoW;
        if (diff == 0) {
            // empty if block
        }
        if (diff < 0) {
            baseDay += Math.abs(diff);
        }
        if (diff > 0) {
            baseDay = baseDay + 7 - diff;
        }
        return (requiredNth - 1) * 7 + baseDay;
    }

    private int generateLValues(On on, int year, int month) throws NoSuchValueException {
        int requiredDoW;
        int lastDoM = new DateTime(year, month, 1, 1, 1).dayOfMonth().getMaximumValue();
        DateTime lastDoMDateTime = new DateTime(year, month, lastDoM, 1, 1);
        int dowForLastDoM = lastDoMDateTime.getDayOfWeek();
        int dowDiff = dowForLastDoM - (requiredDoW = ConstantsMapper.weekDayMapping(this.mondayDoWValue, ConstantsMapper.JODATIME_WEEK_DAY, on.getTime().getValue()));
        if (dowDiff == 0) {
            return lastDoMDateTime.dayOfMonth().get();
        }
        if (dowDiff < 0) {
            return lastDoMDateTime.minusDays(dowForLastDoM + (7 - requiredDoW)).dayOfMonth().get();
        }
        if (dowDiff > 0) {
            return lastDoMDateTime.minusDays(dowDiff).dayOfMonth().get();
        }
        throw new NoSuchValueException();
    }

    private int generateNoneValues(On on, int year, int month, int reference) {
        int dowForFirstDoM = new DateTime(year, month, 1, 1, 1).getDayOfWeek();
        int requiredDoW = ConstantsMapper.weekDayMapping(this.mondayDoWValue, ConstantsMapper.JODATIME_WEEK_DAY, on.getTime().getValue());
        int baseDay = 1;
        int diff = dowForFirstDoM - requiredDoW;
        if (diff == 0) {
            // empty if block
        }
        if (diff < 0) {
            baseDay += Math.abs(diff);
        }
        if (diff > 0) {
            baseDay = baseDay + 7 - diff;
        }
        return baseDay + 7 * (reference / 7);
    }
}

